package walsaip.vte;

import java.io.File;

import edu.uprm.walsaip.vte.core.datatypes.terrain.ElevationData;
import edu.uprm.walsaip.vte.core.datatypes.terrain.VTEInfo;
import edu.uprm.walsaip.vte.core.datatypes.terrain.TextureData;
import edu.uprm.walsaip.vte.core.exceptions.InvalidFileException;
import edu.uprm.walsaip.vte.core.loader.VTEFileLoader;
import edu.uprm.walsaip.vte.core.loader.image.ImageFileLoader;
import edu.uprm.walsaip.vte.core.loader.image.ImageFileLoaderFactory;
import edu.uprm.walsaip.vte.core.loader.terrain.TerrainFileLoader;
import edu.uprm.walsaip.vte.core.loader.terrain.TerrainFileLoaderFactory;

public class DataConverter {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		String infoFilename = args[0];
		String outputPath = args[1];
		
		
		VTEInfo terrainInfo = null;
		try {
			terrainInfo = VTEFileLoader.read(new File(infoFilename));
		} catch (InvalidFileException e) {
			e.printStackTrace();
		}
		String terrainFilename = terrainInfo.getDemSourceFilename();
		String imageFilename = terrainInfo.getTextureSourceFilename();
		int blockSize = terrainInfo.getBlockSize();
		
		
		TerrainFileLoader terrainLoader = TerrainFileLoaderFactory.getLoader(terrainFilename);
		ImageFileLoader imageLoader = ImageFileLoaderFactory.getLoader(imageFilename);
		
		
		ElevationData  elevationData = new ElevationData(terrainInfo);
		terrainLoader.read(elevationData,terrainInfo,new File(terrainFilename));
		
		
		TextureData imageData = new TextureData(terrainInfo);
		imageLoader.read(imageData,terrainInfo,new File(imageFilename));
		//terrainLoader.read(data, info, file)
		
	}

}
