package edu.uprm.walsaip.vte.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;

import javax.imageio.ImageIO;

public class ImageUtils {

	public static String[] getImageIOSupportedFileSuffixes() {
		String suffixes[] = new String[0];
		Method getReaderFileSuffixes = null;
		try {
			getReaderFileSuffixes = ImageIO.class
					.getDeclaredMethod("getReaderFileSuffixes");
		} catch (SecurityException e) {	/* e.printStackTrace();*/} 
		catch (NoSuchMethodException e) {/* e.printStackTrace();*/}
		if (getReaderFileSuffixes != null) {
			try {
				suffixes = (String[]) getReaderFileSuffixes.invoke(
						(Object) null, (Object) null);
				
			} catch (IllegalArgumentException e) { /* e.printStackTrace(); */ 	} 
			catch (IllegalAccessException e) { /* e.printStackTrace(); */}
			catch (InvocationTargetException e) { /* e.printStackTrace(); */ 	}
		}
	
		if (suffixes.length == 0) {
			HashSet<String> suffixSet = new HashSet<String>();
			String formatNames[] = ImageIO.getReaderFormatNames();
			for (String name : formatNames)
				suffixSet.add(name.toLowerCase());
			suffixes = suffixSet.toArray(suffixes);
	
		}
		
		return suffixes;
	}

}
