package edu.uprm.walsaip.vte.core.renderer;


import edu.uprm.walsaip.vte.core.ModuleFactory;
import edu.uprm.walsaip.vte.core.ModuleInfo;


public class RendererFactory  {

	private static ModuleFactory<Renderer> factoryImpl = new  ModuleFactory<Renderer>();
	static {
		// TODO Use property/configuration file or reflection for registering modules 
		RendererFactory.registerModule(GeoMipMapRenderer.MODULE_INFO);
		RendererFactory.registerModule(VBORenderer.MODULE_INFO);
		RendererFactory.registerModule(VertexArrayRenderer.MODULE_INFO);
		}
	
	
	public  static void registerModule(ModuleInfo<? extends Renderer> info) {
		if (info.isSupported()) {
			//System.out.println("Module "+info.getLoaderClass().getSimpleName()+" Registered");
			factoryImpl.registerModule(info);
		}
	}

	public static Renderer getDefaultRenderer() {
		
		return factoryImpl.getModule(0);		
	}
	public static Renderer getRendererByName(String moduleName) {
		return factoryImpl.getModule(moduleName);
	}

}
