/*
*   LODLandscape -- An interface used by various level-of-detail landscape algorithms.
*
*   Copyright (C) 2001-2004 by Joseph A. Huwaldt
*   All rights reserved.
*   
*   This library is free software; you can redistribute it and/or
*   modify it under the terms of the GNU Lesser General Public
*   License as published by the Free Software Foundation; either
*   version 2.1 of the License, or (at your option) any later version.
*   
*   This library is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*   Lesser General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*   Or visit:  http://www.gnu.org/licenses/lgpl.html
**/
package edu.uprm.walsaip.vte.core.model.lod;

//import net.java.games.jogl.GL;
import javax.media.opengl.GL;


/**
*  This is a common interface used by Level-Of-Detail landscape rendering
*  algorithms.
*
*  <p>  Modified by:  Joseph A. Huwaldt   </p>
*
*  @author  Joseph A. Huwaldt   Date:  April 24, 2001
*  @version November 18, 2004
**/
public interface LODLandscape {

	// Drawing Modes
//	public static final int kUseTexture = 0;
//	public static final int kUseFlatShading = 1;
//	public static final int kUseGauradShading = 2;
//	public static final int kUseWireFrame = 3;

	/**
	*  Set the drawing mode to one of the constants defined
	*  in this class.
	**/
	public void setDrawMode(int mode);
	
	/**
	*  Return the drawing mode used by this landscape.
	*  Returns one of the drawing mode constants defined in this class.
	**/
	public int getDrawMode();

	/**
	*  Return the level-of-detail threshold, or triangle count,
	*  or whatever is required to set the level of detail used
	*  by this landscape rendering algorithm.
	**/
	public int getLevelOfDetail();
	
	/**
	*  Set the level-of-detail threshold, or triangle count,
	*  or whatever is required to set the level of detail used
	*  by this landscape rendering algorithm.
	**/
	public void setLevelOfDetail(int number);
	
	/**
	*  Returns the actual number of triangles rendered during
	*  the last pass through the render() method.
	**/
	public int numTrianglesRendered();
	
	/**
	*  Updates the visibility of regions of the terrain for the current view
	*  field and updates any level of detail information required by this
	*  algorithm (such as taking the current view point into consideration
	*  when tesselating).
	*
	*  @param  fovX         The field of view in degrees.
	*  @param  viewPosition The location of the camera in model coordinates.
	*  @param  clipAngle    The direction the camera is pointing.
	**/
	public void update(float fovX, float[] viewPosition, float clipAngle);

	/**
	*  Render the landscape to the specified OpenGL rendering context.
	*
	*  @param  gl   The OpenGL rendering context that we are rendering into.
	**/
	public void render(GL gl);
	
}
