package edu.uprm.walsaip.vte.core.model;

import edu.uprm.walsaip.vte.core.ModuleFactory;
import edu.uprm.walsaip.vte.core.ModuleInfo;

public class TerrainModelFactory {
	
	private static ModuleFactory<TerrainModel> factoryImpl = new  ModuleFactory<TerrainModel>();
	static {
		
		TerrainModelFactory.registerModule(GeoMipMapTerrainModel.MODULE_INFO);
		//TerrainModelFactory.registerModule(FullMeshTerrainModel.MODULE_INFO);
		}
	
	
	public  static void registerModule(ModuleInfo<? extends TerrainModel> info) {
		if (info.isSupported()) {
			factoryImpl.registerModule(info);
		}
	}

	public static TerrainModel getDefaultModel() {
		
		return factoryImpl.getModule(0);
	}
	

	public static TerrainModel getModelByName(String moduleName) {
		return factoryImpl.getModule(moduleName);
	}
}
