package edu.uprm.walsaip.vte.core.model;

import edu.uprm.walsaip.vte.core.Drawable;
import edu.uprm.walsaip.vte.core.Module;
import edu.uprm.walsaip.vte.core.exceptions.FilenameNullException;
import edu.uprm.walsaip.vte.core.exceptions.InvalidFileException;
import edu.uprm.walsaip.vte.core.messagebus.MessageListener;

/**
 * Interface implemented by objects which encapsulate the terrain data management algorithms. 
 * TerrainModel objects interact with the Renderer, Camera and the FileLoader modules in order to render the terrain data.
 * @author Ricardo Veguilla
 *
 */
public interface TerrainModel extends Module, Drawable, MessageListener{
	public static final String ID = TerrainModel.class.getSimpleName();
	
	
	public static final String ROTATE_AROUND_X = "rotateAroundX";
	public static final String ROTATE_AROUND_Y = "rotateAroundY";
	public static final String ROTATE_AROUND_Z = "rotateAroundZ";
	
	public static final String ROTATE_X_PLUS = "rotatePlusX";
	public static final String ROTATE_X_MINUS = "rotateMinusX";
	public static final String ROTATE_Y_PLUS = "rotatePlusY";
	public static final String ROTATE_Y_MINUS = "rotateMinusY";
	public static final String ROTATE_Z_PLUS = "rotatePlusZ";
	public static final String ROTATE_Z_MINUS = "rotateMinusZ";
	
	public static final String MOVE_X_PLUS = "movePlusX";
	public static final String MOVE_X_MINUS = "moveMinusX";
	public static final String MOVE_Y_PLUS = "movePlusY";
	public static final String MOVE_Y_MINUS = "moveMinusY";
	public static final String MOVE_Z_PLUS = "movePlusZ";
	public static final String MOVE_Z_MINUS = "moveMinusZ";

	public static final String SET_PITCH = "setPitch";
	public static final String WINDOW_HEIGHT = "windowHeight";


	public static final String LOAD = "load";
	
	/**
	 * Initialize the TerrainModel object by passing to it the path to the VTE info file for a particular data set. 
	 * @param filename path of the VTE info file (.vte)
	 * @throws FilenameNullException  
	 * @throws InvalidFileException
	 */
	public void init(String filename) throws FilenameNullException, InvalidFileException;
	

}
