package edu.uprm.walsaip.vte.core.messagebus;
import java.util.Timer;
import java.util.TimerTask;

public class MessageTimer {

	private Timer timer;


	private boolean timerStarted = false;		
			
	
	
	public MessageTimer() {
		super();
	}
	
	public MessageTimer(Action action, int delay) {
		super();
	}

	public void startEvent(final Action action,int delay) {
		
		TimerTask task = new TimerTask() {
			public void run() {
				action.exec();			
			}
		};

		if (task != null) {
			timer = new Timer();
			timer.scheduleAtFixedRate(task, 0, delay);
			timerStarted = true;
		}

	}
	
	public void stopEvent() {
		if (timerStarted && timer != null) {
			timer.cancel();
			timer.purge();
			timerStarted = false;
			
		}
	}

	
	public abstract class Action {

		public abstract void exec();
		
	}

	public boolean isTimerStarted() {
		return timerStarted;
	}
	
}
