package edu.uprm.walsaip.vte.core.messagebus;
/**
 * Interface implemented by modules wishing to receive messages from other objects. The object implementing this interface must manually register itself with the MessageBus singleton object.
 * 
 * @author Ricardo Veguilla
 * @see MessageBus, Message
 */
public interface MessageListener {
	/**
	 * Method invoked when this listener receive a message.
	 * @param m Message object received by the listener.
	 */
	public void processEvent(Message<?> m);
}
