package edu.uprm.walsaip.vte.core.messagebus;

/**
 * Object that encapsulate a Message to be delivered through the MessageBus. A Message has the following main atributes: 
 * String name: name of the message.
 * String channel: target channel in the MessageBus.
 * String type: type of message object.
 * T value: object associated with the message.
 *   
 * @author Ricardo Veguilla
 *
 * @param <T> Type of of the value object included in the message.
 */
public final class Message<T> {
	public static final String MSG_START = "start";
	public static final String MSG_STOP = "stop";
	public static final String MSG_INSTANT = "instant";
	public static final String MSG_AUTO_REPEAT = "repeat";
	private final String channel;
	private final String name;
	private final String type;
	private int delay = 1;
	private int count = 1;
	private final T value;
	
	/**
	 * Construct a message object by specify all the message parameters.
	 * @param channel
	 * @param name
	 * @param type
	 * @param delay
	 * @param count
	 * @param value
	 */
	public Message(final String channel, final String name, final String type,int delay, int count, final T value) {
		super();
		this.channel = channel;
		this.name = name;
		this.type = type;
		this.value = value;
		this.delay = delay;
		this.count = count;
	}
	/**
	 * Constructs a message of a particular type with default delay and count parameters (delay = 1, count = 1).
	 * @param channel
	 * @param name
	 * @param type
	 * @param value
	 */
	public Message(final String channel, final String name, final String type, final T value) {
		super();
		this.channel = channel;
		this.name = name;
		this.type = type;
		this.value = value;
	}
	/**
	 * Constructs an instant message.
	 * @param channel
	 * @param name
	 * @param value
	 */
	public Message(String channel,  String name, T value) {
		super();
		this.channel = channel;
		this.name =  name;
		this.type = Message.MSG_INSTANT;
		this.value = value;
	}
	/**
	 * 
	 * @return
	 */
	public final String getName() {
		return new String(name);
	}
	/**
	 * 
	 * @return
	 */
	public final T getValue() {
		return value;
	}
	/**
	 * 
	 * @return
	 */
	public String getChannel() {
		return channel;
	}
	/**
	 * 
	 * @return
	 */
	public String getType() {
		return type;
	}
/**
 * 
 * @return
 */
	public int getCount() {
		return count;
	}
/**
 * 
 * @return
 */
	public int getDelay() {
		return delay;
	}
	/**
	 * Obtains the corresponding start message object for a particular instant message object.
	 * @return Start message for this instant message object.
	 */
	public Message<T> getStartMsg() {
		if (this.type == MSG_INSTANT) {
			return new Message<T>(this.channel,MSG_START,value);
		}
		return null;// TODO throw exception
	}
	/**
	 * Obtains the corresponding stop message object for a particular instant message object.
	 * @return Stop message for this instant message object.
	 */
	public Message<T> getStopMsg() {
		if (this.type == MSG_INSTANT) {
			return new Message<T>(this.channel,MSG_STOP,value);
		}
		return null;// TODO throw exception
	}
	
}
