package edu.uprm.walsaip.vte.core.loader.terrain;



//import static java.lang.System.out;

import java.util.Set;

import javax.swing.filechooser.FileFilter;

import edu.uprm.walsaip.vte.core.loader.FileLoaderFactory;
import edu.uprm.walsaip.vte.core.loader.FileLoaderInfo;




public class TerrainFileLoaderFactory {

	private static FileLoaderFactory<TerrainFileLoader> factoryImpl = new FileLoaderFactory<TerrainFileLoader>();
	
	
	static {
		// TODO Use property/configuration file or reflection for registering modules 
		TerrainFileLoaderFactory.registerModule(BTFileLoader.MODULE_INFO);
		TerrainFileLoaderFactory.registerModule(DEMFileLoader.MODULE_INFO);
		TerrainFileLoaderFactory.registerModule(ImageTerrainFileLoader.MODULE_INFO);
		TerrainFileLoaderFactory.registerModule(EnviTerrainFileLoader.MODULE_INFO);
	}

	
	
	public static void registerModule(FileLoaderInfo<? extends TerrainFileLoader> info) {
		factoryImpl.registerModule(info);
	}

	
	public static FileFilter getFileFilter() {
		return factoryImpl.getFileFilter();
	}

	public static TerrainFileLoader getLoader(String filename) {
		return factoryImpl.getLoader(filename);
	}

		
	public static Set<String> getSuportedExtensions() {
	return factoryImpl.getSuportedExtensions();
	}
	
}
