package edu.uprm.walsaip.vte.core.loader.terrain;


import java.io.File;
import edu.uprm.walsaip.vte.core.datatypes.terrain.ElevationData;
import edu.uprm.walsaip.vte.core.datatypes.terrain.VTEInfo;
import edu.uprm.walsaip.vte.core.loader.FileLoader;

/**
 * Interface implemented by objects that read terrain elevation data from file.
 * @author Ricardo Veguilla
 *
 */
public interface TerrainFileLoader extends FileLoader{

	public static final String ID = TerrainFileLoader.class.getSimpleName();
	/**
	 * Read terrain elevation data from file and stored it on the ElevationData object according to the information provided in the TerrainInfo object.
	 * @param data elevation data object in in which to store the data
	 * @param info terrain info object which describe the terrain data set
	 * @param file reference to the file containing the actual data.
	 */
	public void read(ElevationData data,VTEInfo info, File file);
	
	
	
	
}