/**
 * 
 */
package edu.uprm.walsaip.vte.core.loader.terrain;

// import static java.lang.System.err;
import static java.lang.System.out;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import edu.uprm.walsaip.vte.core.datatypes.terrain.ElevationData;
import edu.uprm.walsaip.vte.core.datatypes.terrain.VTEInfo;
import edu.uprm.walsaip.vte.core.loader.FileLoaderInfo;
import edu.uprm.walsaip.vte.core.util.ImageUtils;


/**
 * 
 * @author Ricardo Veguilla (veguilla@ece.uprm.edu)
 * 
 */
public class ImageTerrainFileLoader implements TerrainFileLoader {

	public static final String ID = ImageTerrainFileLoader.class.getSimpleName();
	public static final String Type = TerrainFileLoader.ID;

	
	public static final FileLoaderInfo<ImageTerrainFileLoader> MODULE_INFO = new FileLoaderInfo<ImageTerrainFileLoader>() {
		
		protected void setInfo() {
			name = ImageTerrainFileLoader.ID;
			description = "Image terrain file";
			moduleClass = ImageTerrainFileLoader.class;
			extensionList = ImageUtils.getImageIOSupportedFileSuffixes();
			supported = true;
		}
	};

	
	
	public ImageTerrainFileLoader() {
		super();
	}
	
	@Override
	public void read(ElevationData data, VTEInfo info, File file) {
		out.printf("Reading terrain file...");
		

		BufferedImage bufferedImage = null;
		try {
			bufferedImage = ImageIO.read(file);
		} catch (IOException e) {
			e.printStackTrace();
		}

		
		int width = bufferedImage.getWidth();
		int height = bufferedImage.getHeight();
		

		data.setFile(file);
	
		data.setGridSpacingX(15);
		data.setGridSpacingY(15);
		
		Raster raster = bufferedImage.getRaster();

		ColorModel colorModel = bufferedImage.getColorModel();
		int numComponents = colorModel.getNumComponents();
		
		if (false) {
		out.println("Dimensions: " + width + " " + height);
		out.println("Number of Component per Pixel: " + numComponents);
		for (int i = 0; i < numComponents; i++) 
			out.println("Bits per Component[" + i + "] = "+ colorModel.getComponentSize(i));
		}
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) 
				 data.putSample(x,y,0,raster.getSampleFloat(x, y, 0)) ;
			
		}
		out.println("done");

		
	}


	
}
