package edu.uprm.walsaip.vte.core.loader.image;

//import static java.lang.System.out;
import static java.lang.System.out;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import edu.uprm.walsaip.vte.core.datatypes.terrain.VTEInfo;
import edu.uprm.walsaip.vte.core.datatypes.terrain.TextureData;
import edu.uprm.walsaip.vte.core.loader.FileLoaderInfo;
import edu.uprm.walsaip.vte.core.util.ImageUtils;

public class ImageIOFileLoader implements ImageFileLoader {

	public static final String ID = ImageIOFileLoader.class.getSimpleName();
	public static final String Type = ImageFileLoader.ID;

	public static final FileLoaderInfo<ImageIOFileLoader> MODULE_INFO = new FileLoaderInfo<ImageIOFileLoader>() {
		@Override
		protected void setInfo() {
			name = ImageIOFileLoader.ID;
			description = "Image file";
			moduleClass = ImageIOFileLoader.class;
			extensionList = ImageUtils.getImageIOSupportedFileSuffixes();
			supported = true;
		}
	};
	


	public ImageIOFileLoader() {
		super();
	}
	@Override
	public void read(TextureData data,VTEInfo info,File file) {

		
		out.printf("Reading image file...");
		BufferedImage bufferedImage = null;
		try {
			bufferedImage = ImageIO.read(file);
		} catch (IOException e) {
			e.printStackTrace();
		}	
		int width = bufferedImage.getWidth();
		int height = bufferedImage.getHeight();
	
		ColorModel colorModel = bufferedImage.getColorModel();
		int numComponents = colorModel.getNumComponents();
		int componentSize [] = new int[numComponents];
		for (int i = 0; i< numComponents; i++) 
			componentSize[i] = colorModel.getComponentSize(i);
		
		if (true) {
		out.println();
		out.println("Image Type: "+imageTypeString(bufferedImage.getType()));
		out.println("Dimensions: "+width +" "+ height);
		out.println("Number of Component per Pixel: "+numComponents);

		for (int i = 0; i< numComponents; i++) 
			out.println("Bits per Component["+i+"] = "+ componentSize[i]);
		}
		
		
		
		
		Raster img = bufferedImage.getData();

		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				for (int c = 0; c < 3;c++) {
					data.putSample(x,y,c, (byte) (img.getSample(x, y, c)));///   /componentSize[c]));
				}

			}
		}

		
		data.setFile(file);	
		out.println("done");
		
	}

	private String imageTypeString(int type) {
		
		
		switch (type) {
		case BufferedImage.TYPE_INT_RGB : return "TYPE_INT_RGB";
		case BufferedImage.TYPE_INT_ARGB:  return "TYPE_INT_ARGB";
		case BufferedImage.TYPE_INT_ARGB_PRE: return "TYPE_INT_ARGB_PRE";
		case BufferedImage.TYPE_INT_BGR:  return "TYPE_INT_BGR"; 
		case BufferedImage.TYPE_3BYTE_BGR:  return "TYPE_3BYTE_BGR";
		case BufferedImage.TYPE_4BYTE_ABGR:  return "TYPE_4BYTE_ABGR";
		case BufferedImage.TYPE_4BYTE_ABGR_PRE: return "TYPE_4BYTE_ABGR_PRE";
		case BufferedImage.TYPE_BYTE_GRAY: return "TYPE_BYTE_GRAY";
		case BufferedImage.TYPE_BYTE_BINARY: return "TYPE_BYTE_BINARY";
		case BufferedImage.TYPE_BYTE_INDEXED: return "TYPE_BYTE_INDEXED";
		case BufferedImage.TYPE_USHORT_GRAY: return "TYPE_USHORT_GRAY";
		case BufferedImage.TYPE_USHORT_565_RGB: return "TYPE_USHORT_565_RGB";
		case BufferedImage.TYPE_USHORT_555_RGB: return "TYPE_USHORT_555_RGB";
		case BufferedImage.TYPE_CUSTOM: return "TYPE_CUSTOM";
		
		}
		
		return "ERROR";
	}

}
