package edu.uprm.walsaip.vte.core.loader.image;


import java.io.File;
import edu.uprm.walsaip.vte.core.datatypes.terrain.VTEInfo;
import edu.uprm.walsaip.vte.core.datatypes.terrain.TextureData;
import edu.uprm.walsaip.vte.core.loader.FileLoader;

/**
 * Interface implemented by objects that read terrain image data from file.
 * @author Ricardo Veguilla
 *
 */
public interface ImageFileLoader extends FileLoader{
	public static final String ID = ImageFileLoader.class.getSimpleName();
	/**
	 * Read terrain image data from file and stored it on the TextureData object according to the information provided in the TerrainInfo object.
	 * @param data texture data object in in which to store the data
	 * @param info terrain info object which describe the terrain data set
	 * @param file reference to the file containing the actual data.
	 */
	public void read(TextureData data, VTEInfo info, File filename);
}
