package edu.uprm.walsaip.vte.core.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.swing.filechooser.FileFilter;

import edu.uprm.walsaip.vte.core.datatypes.terrain.VTEInfo;
import edu.uprm.walsaip.vte.core.exceptions.InvalidFileException;
/**
 * Utility class that reads a VTE description file (.vte) and generates a corresponding TerrainInfo object. 
 * @author Ricardo Veguilla
 *
 */
public class VTEFileLoader  {
	protected static String extension =  "vte" ;


	/**
	 * Obtain a FileFilter object used by the Swing open dialogs.
	 * @return a file filter for this file type.
	 */
	public static FileFilter getFileFilter() {
		return new FileFilter() {
			public boolean accept(File f) {
				if (f.isDirectory())
					return true;
				else if (f.isFile()) {

					return f.getName().endsWith(extension);
				}
				return false;

			}

			public String getDescription() {
				// TODO Fix getFileFilter...
				return "Supported files";
			}
		};
	}
	private VTEFileLoader() {
		super();
	}
	/**
	 * Read a VTE info file and generate the corresponding TerrainInfo object.
	 * @param file Reference to the VTE info file (.vte)
	 * @return terrain info object corresponding to the VTE info file.
	 * @throws InvalidFileException file format is incrrect.
	 */
	public static VTEInfo read(File file) throws InvalidFileException {
		boolean valid = false;
		VTEInfo info = new VTEInfo();
		info.setFilename(file.getAbsolutePath());
		try {
			FileInputStream input = new FileInputStream(file);
			BufferedReader reader = new BufferedReader(new InputStreamReader(input));
			String line = null;

			while((line = reader.readLine())!= null) {
				//lines.add(line);
				//System.out.println(line);
		
				if(line.startsWith("VTE")) {
					valid = true;
				}
//				else if (line.startsWith("description")) {
//					header.description = parseBlock(reader);
//				}
				else if (line.startsWith("block_size")) {
					info.setBlockSize(Integer.parseInt(parseValue("block_size",line)));
				}
				else if (line.startsWith("x_blocks")) {
					info.setXBlocks(Integer.parseInt(parseValue("x_blocks",line)));
				}
				else if (line.startsWith("y_blocks" )) {
					info.setYBlocks(Integer.parseInt(parseValue("y_blocks",line)));
				}
				else if (line.startsWith("dem_width")) {
					info.setDemWidth(Integer.parseInt(parseValue("dem_width",line)));
				}
				else if (line.startsWith("dem_height")) {
					info.setDemHeight(Integer.parseInt(parseValue("dem_height",line)));
				}
				else if (line.startsWith("texture_width")) {
					info.setTextureWidth(Integer.parseInt(parseValue("texture_width",line)));
				}
				else if (line.startsWith("texture_height")) {
					info.setTextureHeight(Integer.parseInt(parseValue("texture_height",line)));
				}
				else if (line.startsWith("dem_source_filename")) {
					info.setDemSourceFilename(parseValue("dem_source_filename",line));
				}
				else if (line.startsWith("texture_source_filename")) {
					info.setTextureSourceFilename(parseValue("dem_source_filename",line));
				}
				else if (line.startsWith("dem_blocks")) {
					info.setDemBlocks(parseList(parseBlock(reader)));
				}
				else if (line.startsWith("texture_blocks")) {
					info.setTextureBlocks(parseList(parseBlock(reader)));
				}
			}
			
			reader.close();
			input.close();
			
		} catch (FileNotFoundException e) {
		
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		if(!valid) {
			throw new InvalidFileException(file.getAbsolutePath());
		}
		return info;
	}

	
	
	
	private static List<String> parseList(String line) {
		List<String> list = new ArrayList<String>();
		StringTokenizer tokenizer = new StringTokenizer(line);
		String token;
		while(tokenizer.hasMoreTokens()) {
			token = tokenizer.nextToken(",").trim();
			list.add(token);
			//System.out.println(token);
		}
		return list;
	}
	private static String parseBlock (BufferedReader reader) throws IOException {
		String line = reader.readLine().trim();
		
		StringBuffer block = new StringBuffer();
		while (!line.endsWith("}")) {
			block.append(line);
			line = reader.readLine().trim();
		}
		block.append(line.substring(0, line.length()-1));
		
		return block.toString();
	}

	private static String parseValue(String name,String line) {
		String value =line.substring(line.indexOf("=")+1).trim();
	//	System.out.printf("name = %s | value = %s \n",name,value);
		return value;
		
	}
}

