package edu.uprm.walsaip.vte.core.datatypes.terrain;

import java.nio.ByteBuffer;

import edu.uprm.walsaip.vte.core.util.BufferUtils;

public class TextureData extends AbstractTerrainData{
	
	private int bands = 4;
	
	private ByteBuffer buffer;
	
	
	public TextureData(VTEInfo info) {
		super(info.getTextureWidth(),info.getTextureHeight(),info.getBlockSize());
				
		buffer = BufferUtils.tryAllocateDirect(this.width*this.height*bands);
		
		
		
		
		for (int x = 0; x< width; x++) 
			for (int y = 0; y< height; y++) {
				
				buffer.put((bands*width*y)+(x*bands)+0, (byte)128);		
				buffer.put((bands*width*y)+(x*bands)+1, (byte)128);
				buffer.put((bands*width*y)+(x*bands)+2, (byte)128);
				buffer.put((bands*width*y)+(x*bands)+3, (byte)255);
			}
		
	}

	public int getNumBands() {
		return bands;
	}

	public void putSample(int x, int y, int b, byte sample) {
		int index = (bands*width*y)+(x*bands)+b;
		buffer.put(index, sample);
	}
	

	public ByteBuffer getByteBuffer() {
		return buffer;
	}

	@Override
	public void putSample(int x, int y, int b, float sample) {
		int index = (bands*width*y)+(x*bands)+b;
		buffer.put(index, (byte)sample);
		
	}

}
