package edu.uprm.walsaip.vte.core.datatypes.terrain;

import java.io.File;





/**
 * Type interface for objects which represent terrain data, typically either digital elevation model or satellite images.
 * @author Ricardo Veguilla
 *
 */
public interface TerrainData {
	
	public final static int DATA_TYPE_BYTE=0;
	public final static int DATA_TYPE_INT=1;
	public final static int DATA_TYPE_FLOAT=2;
	
	public File getFile();
	public void setFile(File file);

	
	public int getHeight() ;
	public int getWidth() ;
	public int getDataType();

	public void putSample(int x, int y,int b, float sample);
	public void putSample(int x, int y, int b, byte sample);
	
	public float getGridSpacingY();
	public float getGridSpacingX();
	public void setGridSpacingX(float gridSpacingX);
	public void setGridSpacingY(float gridSpacingY);
	
	
}
