package edu.uprm.walsaip.vte.core.datatypes.terrain;
//import static java.lang.System.out;

import edu.uprm.walsaip.vte.core.datatypes.BoundingBox;


/**
 * 
 * @author Ricardo Veguilla (veguilla@ece.uprm.edu)
 *
 */
public class ElevationData extends AbstractTerrainData {
	
	

	private BoundingBox box;
	private float array[][][]; 
	
	
	private float maxElevation = Float.MIN_VALUE;
	private float minElevation = Float.MAX_VALUE;
	
	
	public ElevationData(VTEInfo info) {
		super(info.getDemWidth(),info.getDemHeight(),info.getBlockSize());
		this.box = new BoundingBox(this.width+1,this.height+1);
		this.array = new float[this.height+1][this.width+1][1];
			
	}

	
	public float getElevation() {
		return box.getElevation();
	}



	public BoundingBox getBoundingBox() {
		if (box.getMinElevation() != minElevation)
			box.setMinElevation(minElevation);
		if (box.getMaxElevation() != maxElevation)
			box.setMaxElevation(maxElevation);
		
	return box;
	}

	
	public float getSample(int x, int y,int b) {
		return array[x][y][b];
	}

	
	@Override
	public void putSample(int x, int y, int b, float sample) {
		if (sample > maxElevation)
			maxElevation = sample;
		if (sample < minElevation) 
			minElevation = sample;
		array[y][x][b] = sample; 
	}

	@Override
	public void putSample(int x, int y, int b, byte sample) {
		if (sample > maxElevation)
			maxElevation = sample;
		if (sample < minElevation) 
			minElevation = sample;
		array[y][x][b] = sample; 
		
	}
	
	public float[][][] getAsArray() {
		return this.array;
	}
	public float get(int h, int v) {
		
		return this.array[v][h][0];
	}

	


	
}
