package edu.uprm.walsaip.vte.core.datatypes.terrain;

import java.io.File;

public abstract class AbstractTerrainData implements TerrainData{
	

	protected int width;
	protected int height;
	protected float gridSpacingX = 1;
	protected float gridSpacingY = 1;
	
	private File file;

	protected int blockSize = 64;
	protected int dataType = DATA_TYPE_BYTE;
	
	public AbstractTerrainData(int width, int height,int blockSize) {
		this.blockSize = blockSize;
		
		int h = height;
		int w = width;
		
		int hmod = height % blockSize;
		int wmod = width % blockSize;
		if(hmod != 0) {
			h = h +(blockSize-hmod);
		}
		if(wmod != 0) {
			w = w +(blockSize-wmod);
		}
		
		this.width = w;
		this.height = h;
		
		
	}

	@Override
	public final File getFile() {
		return file;
	}

	@Override
	public final int getHeight() {
		return height;

	}


	@Override
	public final int getWidth() {
		return width;
	}


	@Override
	public final void setFile(File file) {
		this.file = file;
		
	}

	@Override
	public final float getGridSpacingX() {
		return gridSpacingX;
	}

	@Override
	public final float getGridSpacingY() {
		return gridSpacingY;
	}

	@Override
	public final void setGridSpacingX(float gridSpacingX) {
		this.gridSpacingX = gridSpacingX;
		
	}

	@Override
	public final void setGridSpacingY(float gridSpacingY) {
		this.gridSpacingY = gridSpacingY;
	}

	@Override
	public final int getDataType() {
		return dataType;
	}

}
