/**
 * 
 */
package edu.uprm.walsaip.vte.core.datatypes;

import java.awt.Color;

import javax.media.opengl.GL;

import edu.uprm.walsaip.vte.core.Drawable;


/**
 * @author Ricardo Veguilla (veguilla@ece.uprm.edu)
 *
 */
public class Light implements Drawable{

	
	public static int AMBIENT =   				0;
	public static int DIFFUSE	=				1;
	public static int SPECULAR =   			2;
	public static int POSITION =   			3;
	public static int DIRECTION =  			4;
	public static int EXPONENT =   			5;
	public static int CUTOFF =      			6;
	public static int CONST_ATTENUATION =    	7;
	public static int LINEAR_ATTENUATION =   	8;
	public static int QUADRATIC_ATTENUATION = 	9;


	
	  private Color ambient;
	  private Color diffuse;
	  private Color specular;
	  private Position position;
	  private float exponent = 0.0f;
	  private float cutoff = 180.0f;
	  private float constantAttenuation = 1.0f;
	  private float linearAttenuation = 0.0f;
	  private float quadraticAttenuation = 0.0f;
	  private int id;
	  private static int nextID = GL.GL_LIGHT0;
	
	  public Light(int id) {
		
		  this.id = id;
		  
		  this.ambient = new Color ( 0.8f, 0.8f, 0.8f, 0.0f);
		  this.diffuse = new Color (1f, 1f, 1f, 0.0f);
		  this.specular = new Color (0.0f,0.0f,0.0f,1.0f);
		  this.position = new Position(new Vertex (0.0f,0.0f,0.0f,0.0f),new Angle(0.0f,0.0f,-1.0f));
		
		  //direction = new Vector(0.0f,-1.0f,0.0f,1.0f);
	  }
	  
//	  public Light(Position position) {
//		  this();
//		  this.position = position;
//	  }

	/**
	 * @return Returns the ambient.
	 */
	public Color getAmbient() {
		return ambient;
	}

	public void init(GL gl) {
		this.id = nextID;
		//TODO keep internal count of GL_Lights in use 
	}
//	public void init(int id) {
//		this.id = id; 
//	}
	public int render(GL gl){
		gl.glLightfv(id,GL.GL_AMBIENT,ambient.getRGBComponents(null),0);
		gl.glLightfv(id,GL.GL_DIFFUSE,diffuse.getRGBComponents(null),0);
		gl.glLightfv(id,GL.GL_SPECULAR,specular.getRGBComponents(null),0);
		gl.glLightfv(id, GL.GL_POSITION, position.getPosition().array, 0);
		gl.glLightfv(id, GL.GL_SPOT_DIRECTION, position.getForward().array, 0);
		gl.glLightf(id, GL.GL_SPOT_CUTOFF, cutoff);
		gl.glLightf(id, GL.GL_SPOT_EXPONENT, exponent);
		gl.glLightf(id,GL.GL_CONSTANT_ATTENUATION,constantAttenuation);
		gl.glLightf(id,GL.GL_LINEAR_ATTENUATION,linearAttenuation);
		gl.glLightf(id,GL.GL_QUADRATIC_ATTENUATION,quadraticAttenuation);
		
		
		gl.glEnable(id);
		return 0;
	}

	/**
	 * @param ambient The ambient to set.
	 */
	public void setAmbient(Color ambient) {
		this.ambient = ambient;
	}


	
	


	/**
	 * @return Returns the constantAttenuation.
	 */
	public float getConstantAttenuation() {
		return constantAttenuation;
	}


	/**
	 * @param constantAttenuation The constantAttenuation to set.
	 */
	public void setConstantAttenuation(float constAttenuation) {
		this.constantAttenuation = constAttenuation;
	}


	/**
	 * @return Returns the cutoff.
	 */
	public float getCutoff() {
		return cutoff;
	}


	/**
	 * @param cutoff The cutoff to set.
	 */
	public void setCutoff(float cutoff) {
		this.cutoff = cutoff;
	}




	/**
	 * @return Returns the diffuse.
	 */
	public Color getDiffuse() {
		return diffuse;
	}


	/**
	 * @param diffuse The diffuse to set.
	 */
	public void setDiffuse(Color diffuse) {
		this.diffuse = diffuse;
	}



	/**
	 * @return Returns the exponent.
	 */
	public float getExponent() {
		return exponent;
	}


	/**
	 * @param exponent The exponent to set.
	 */
	public void setExponent(float exponent) {
		this.exponent = exponent;
	}


	/**
	 * @return Returns the id.
	 */
	public int getId() {
		return id;
	}


	/**
	 * @param id The id to set.
	 */
	public void setId(int id) {
		this.id = id;
	}


	/**
	 * @return Returns the linearAttenuation.
	 */
	public float getLinearAttenuation() {
		return linearAttenuation;
	}


	/**
	 * @param linearAttenuation The linearAttenuation to set.
	 */
	public void setLinearAttenuation(float linearAttenuation) {
		this.linearAttenuation = linearAttenuation;
	}


	/**
	 * @return Returns the position.
	 */
	public Position getPosition() {
		return position;
	}


	/**
	 * @param position The position to set.
	 */
	public void setPosition(Position position) {
		this.position = position;
	}


	/**
	 * @return Returns the quadraticAttenuation.
	 */
	public float getQuadraticAttenuation() {
		return quadraticAttenuation;
	}


	/**
	 * @param quadraticAttenuation The quadraticAttenuation to set.
	 */
	public void setQuadraticAttenuation(float quadraticAttenuation) {
		this.quadraticAttenuation = quadraticAttenuation;
	}





	/**
	 * @return Returns the specular.
	 */
	public Color getSpecular() {
		return specular;
	}


	/**
	 * @param specular The specular to set.
	 */
	public void setSpecular(Color specular) {
		this.specular = specular;
	}


//	private static int getNextID(){
//		
//	}


	
}
