package edu.uprm.walsaip.vte.core.datatypes;


public final class BoundingBox {

	private int width = 0;
	private int height = 0;
	//private float elevation = 0;
	private float maxElevation = Float.MIN_VALUE;
	private float minElevation = Float.MAX_VALUE;
	
	public BoundingBox() {
		super();
	}

	public BoundingBox(int width, int height ,float minElevation, float maxElevation ) {
		super();
			this.width = width;
		this.height = height;
		this.minElevation = minElevation;
		this.maxElevation = maxElevation;
		
		
	}
	

	
	public BoundingBox(int width, int height) {
		this.width = width;
		this.height = height;
	}

	public float getElevation() {
		return maxElevation-minElevation;
	}
	public int getHeight() {
		return height;
	}
	public int getWidth() {
		return width;
	}
	
	public void setHeight(int height) {
		this.height = height;
	}
	public void setWidth(int width) {
		this.width = width;
	}


	public float getMaxElevation() {
		return maxElevation;
	}

	//public float getElevationCenter(){
	//	return 
//	}
	
	public void setMaxElevation(float maxElevation) {
		this.maxElevation = maxElevation;
	}

	public float getMinElevation() {
		return minElevation;
	}

	public void setMinElevation(float minElevation) {
		this.minElevation = minElevation;
	}

	public static BoundingBox min(BoundingBox a, BoundingBox b) {
		if (a.getVolume() < b.getVolume())
			return a;
		else 
			return b;
	}

	public BoundingBox getScaledInstance(float scale) {
		
		return new BoundingBox(height,width,minElevation*scale,maxElevation*scale);
		
	}
	
	public static BoundingBox max(BoundingBox a, BoundingBox b) {
		
		if (a.getVolume() > b.getVolume())
			return a;
		else 
			return b;
		
		
	}
	
	public static BoundingBox enclosingBox(BoundingBox a, BoundingBox b) {
		int height = (a.height > b.height ? a.height: b.height);
		int width = (a.width > b.width ? a.width: b.width);
		
		float maxElevation = (a.maxElevation > b.maxElevation ? a.maxElevation: b.maxElevation);
		float minElevation = (a.minElevation < b.minElevation ? a.minElevation: b.minElevation);
		
		return new BoundingBox(width,height,minElevation,maxElevation);
	}
	
	
	public float getVolume() {
		return ((float)height * width) * getElevation();
		
	}
}
