package edu.uprm.walsaip.vte.core.camera;

import edu.uprm.walsaip.vte.core.ModuleFactory;
import edu.uprm.walsaip.vte.core.ModuleInfo;

public class CameraFactory {

	private static ModuleFactory<Camera> factoryImpl = new  ModuleFactory<Camera>();
	private static Camera currentCamera =  null;
	static {
		CameraFactory.registerModule(Fully3DCamera.MODULE_INFO);
		CameraFactory.registerModule(LookAtCamera.MODULE_INFO);
		}
	
	
	public static void registerModule(ModuleInfo<? extends Camera> info) {
		factoryImpl.registerModule(info);
	}

	public static Camera getDefaultCamera() {
		
		return getCamera("Fully3DCamera");
	}
	
	public static Camera getCamera(String name){
		return factoryImpl.getModule(name);
	}

	public static void setCurrentCamera(Camera camera) {
		CameraFactory.currentCamera = camera;	
	}
	public static Camera getCurrentCamera() {
		return CameraFactory.currentCamera;	
	}
}
