package edu.uprm.walsaip.vte.core.camera;

import edu.uprm.walsaip.vte.core.Drawable;
import edu.uprm.walsaip.vte.core.Module;
import edu.uprm.walsaip.vte.core.datatypes.Light;
import edu.uprm.walsaip.vte.core.datatypes.Position;
import edu.uprm.walsaip.vte.core.messagebus.MessageListener;

/**
 * Interface implemented by objects which control the virual camera which defines the view position and orientation. 
 * @author Ricardo Veguilla
 *
 */
public interface Camera extends Module , Drawable, MessageListener{
	public static final String ID = Camera.class.getSimpleName();
	public static final String MOVE_FORWARD = "moveForward";
	public static final String MOVE_BACKWARD = "moveBackward";
	public static final String MOVE_UP = "moveUp";
	public static final String MOVE_DOWN = "moveDown";
	public static final String MOVE_LEFT= "moveLeft";
	public static final String MOVE_RIGHT = "moveRight";
	public static final String ROTATE_UP = "rotateUp";
	public static final String ROTATE_DOWN = "rotateDown";
	public static final String ROTATE_LEFT = "rotateLeft";
	public static final String ROTATE_RIGHT = "rotateRight";
	public static final String ROLL_LEFT = "rollLeft";
	public static final String ROLL_RIGHT = "rollRight";
	public static final String SET_MOVEMENT_OFFSET = "setMovementOffset";
	public static final String SET_ANGLE_DELTA = "setAngleDelta";
	public static final String SET_POSITION = "setPosition" ;
	public static final String SET_HEIGHT = "setHeight" ;
	public static final String SET_MAX_MODEL_ELEVATION ="setMaxModelElevation";

	/**
	 * 
	 * @return the position object associated with this camera object.
	 */
	public Position getPosition();
	/**
	 * 
	 * @return the light object associated with this camera object.
	 */
	public Light getLight();
	
	/**
	 * 
	 * @param light light object to use
	 */
	public void setLight(Light light);
	/**
	 * 
	 * @param position position object to use
	 */
	public void setPosition(Position position);

	
}
