package edu.uprm.walsaip.vte.core;


/**
 * 
 * Object which encapsulate module information used by the different Module factories.
 * @author Ricardo Veguilla
 *
 * @param <E> Module interface type described by this object.
 */
public abstract class ModuleInfo <E extends Module>{

	protected String name;
	protected String description;
	protected Class<E> moduleClass;
	protected boolean supported = false;
	public ModuleInfo() {
		setInfo();
	}

	/**
	 * @return module name string.
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return module's class object.
	 */
	public Class<E> getModuleClass() {
		return moduleClass;
	}


	/**
	 * @return module's description string.
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * 
	 * @return module's key string.
	 */
	public String getKey() {
		return name;
	}
	
	/**
	 * Abstract method to be implemented by sub-classes, though which they set the module info properties.
	 */
	abstract protected void setInfo();
	/**
	 * Method to verify if the module is supported in the current system.
	 * @return true if the module is supported, otherwise returns false.
	 */
	public boolean isSupported() {
		return supported;
	}
}
