package edu.uprm.walsaip.vte.core;

import javax.media.opengl.GL;


/**
 * 
 * @author Ricardo Veguilla
 * 
 * Interface for all modules or objects which contribute to the scene rendering.
 *
 */
public interface Drawable extends Module {
	/**
	 * Method invoked to draw this object.
	 * @param gl Reference to the current GL object through which the rendering is actually performed.
	 * @return Number of triangles rendered.
	 */
	public int render(GL gl);
	/**
	 * Method invoked during the initialization phase to both initialize this object and to allow the object to adjust the rendering state for subsequent operations. 
	 * @param gl gl Reference to the current GL object through which the initialization is actually performed
	 */
	public void init(GL gl);
}
