package com.c5corp.c5viewUi;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.filechooser.FileFilter;
import java.io.*;
import com.c5corp.c5dem.*;

/**
* Main Method for testing DEM Imaging
*
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public class DemTool {

   /**
    * Main Method creates a viewer for DEM Imaging and viewing elevations, UTM points
    */

    public static void main (String[] args) {

		System.out.println("DemTool: " + C5DemConstants.copy);

		// create a DemTable object

		if (args.length == 1) {
			createViewer(args[0]);
		} else if (args.length == 0) {
			createViewer();
		} else {
			return;
		}
	}

    /**
     * this method calls openFile() of ViewerDisplayPanel to get a file
     * then calls createViewer(String filename)
     */

	static protected void createViewer() {
		// catch the NullPointerException generated if the user cancels,
		// and the FileNotFoundException if they fail to select a DEM in
		// the JDialog
		try {
			createViewer(openFile().getAbsolutePath());
		} catch (NullPointerException e) {	// just exit(0)
			System.exit(0);
		}
	}

   /**
    * creates a viewer when the filename is specified at the command line...
    */

	static private void createViewer(String filename) {

		// create the dem table
		DemTable demtable= new DemTable(filename);

		// make a DemImagePanel
		DemImagePanel demimg = new DemImagePanel(demtable, DemImagePanel.GRAYSCALE);

		// make a Jframe (window)
		JFrame f = new JFrame("C5 DEM Tool: " + demtable.get_file_name());

		// make a scrollpane - (just in case the image is really big
		JScrollPane scrollpane = new JScrollPane(demimg);

		//JScrollPane scrollpane = new JScrollPane(new DemImagePanel());
		// uses test constructor - will remove that later...
		scrollpane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED );
		scrollpane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED );

		// create a ViewerDisplayPanel to display coordinates
		ViewerDisplayPanel display = new ViewerDisplayPanel(demtable, demimg, f);

		// add to the Jframe
		f.getContentPane().setLayout(new BorderLayout());
		f.setLocation(0,0);
		f.getContentPane().add(scrollpane, BorderLayout.CENTER);
		f.getContentPane().add(display, BorderLayout.SOUTH);
		f.addWindowListener( new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});

		// take care of the window...
		Toolkit kit= Toolkit.getDefaultToolkit();

		// start with max size
		int wid = kit.getScreenSize().width;
		int hi = kit.getScreenSize().height-30; // make room for menus, taskbar, etc...

		// adjust the window width
		if (demimg.getWidth() <= wid) {
			wid = demimg.getWidth()+25;
		}
		// adjust the window height
		if (demimg.getHeight()+140 <= hi) {
			hi = demimg.getHeight()+140;
		}
		f.setSize(wid, hi + display.getHeight());
		f.setVisible(true);

		demimg.addMouseMotionListener(display);
	}

	/**
	 * this file opener can be used where ever.
	 */

	protected static File openFile() {
		JFileChooser fc = new JFileChooser(".");
		fc.setFileFilter(new DemFileFilter());
		switch (fc.showOpenDialog(fc)) {
			case JFileChooser.CANCEL_OPTION:
				// do nothing
				return null;
			case JFileChooser.ERROR_OPTION:
				// JOptionPane.showMessageDialog(null, "File open error");
				// do nothing
				return null;
		}
		return fc.getSelectedFile();
	}

	/**
	 * overrides java.lang.Object.toString()
	 */

	public String toString() {
		return this.getClass().getName() + C5DemConstants.copy;
	}
}

