package com.c5corp.c5viewUi;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import com.c5corp.c5dem.*;

/**
* extention of JPanel to image DemTable objects
* Extends JPanel, implements Scrollable.
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public class DemImagePanel extends JPanel
		implements Scrollable {

	//declarations
	private DemTable demtab;
	private short minimumelevation;
   	private short maximumelevation;
	private BufferedImage image;
	private int width, height;
	private UtmCoordinatePairElev[][] table;

	public static final int GRAYSCALE=0;
	public static final int COLOR=1;
	boolean is_color;

	/**
	 * constructor
	*/
	public DemImagePanel(DemTable demtab, int BWORCOLOR) {
		this.demtab = demtab;
		table = demtab.getTable();
		switch (BWORCOLOR) {
			case 0:		// static final int GRAYSCALE
				showGrayScale();
				break;
			case 1:		// static final COLOR
				showColor();
				break;
			default:
				showGrayScale();
		}
	}

	/**
	 * converts to grayscale image
	*/
	public void showGrayScale() {
		int[] data;
		int temp;
		is_color=false;

		// determine size of image from dem (pixel per row and column)
		width=demtab.get_column_count();
		height=demtab.maxElevationsForAllProfiles();
		setPreferredSize(new Dimension(width,height));
		int zero_elevation_offset=0;

		// get min and max elevations and difference
		minimumelevation=(short)demtab.get_min_and_max_values()[0];
		maximumelevation=(short)demtab.get_min_and_max_values()[1];

		// adjust for negative values (below sea level)
		if (minimumelevation<0) {
			zero_elevation_offset=java.lang.Math.abs(minimumelevation);
		}
		double ratio=((double)255)/(maximumelevation-minimumelevation);
		// fill the array - this is really inefficient right now
		// need a second method for zero elevation offset
		data= new int[width*height];

		for (int i=0; i < width; i++) { // iterate arrays
			for (int j=0; j < height; j++) {
				if (table[i][j] != null) {
					//map to grayscale
					temp = (int)(((table[i][j].getElevation() - minimumelevation) +
						  zero_elevation_offset) * ratio);
					// Add to array
					data[(j * width) + i] = (temp << 16) | (temp << 8) | (temp);
				}
			}
		}

		// build the image
		image= new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		image.setRGB(0,0,width,height,data,0,width);
		repaint();
	}

	/**
	 * converts to color image
	*/
	public void showColor() {
		int[] data;
		int temp;
		int red;
		int green;
		int blue;
		is_color=true;
		// determine size of image from dem (pixel per row and column)
		width=demtab.get_column_count();
		height=demtab.maxElevationsForAllProfiles();
		setPreferredSize(new Dimension(width,height));
		int zero_elevation_offset=0;

		// get min and max elevations and difference
		minimumelevation=(short)demtab.get_min_and_max_values()[0];
		maximumelevation=(short)demtab.get_min_and_max_values()[1];
		// adjust for negative values (below sea level)
		if (minimumelevation<0) {
			zero_elevation_offset=java.lang.Math.abs(minimumelevation);
		}
		double ratio=((double)1275)/(maximumelevation-minimumelevation);
		// fill the array - this is really inefficient right now
		// need a second method for zero elevation offset
		data= new int[width*height];

		for (int i=0; i < width; i++) { // iterate arrays
			for (int j=0; j < height; j++) {
				if (table[i][j] != null) {
					red = 0;
					green = 0;
					blue = 0;

					//map to color
					temp=(int)(((table[i][j].getElevation() - minimumelevation) + zero_elevation_offset) * ratio);
					if (temp  > 1020) { // cyan toward yellow
						red = temp - 1020;
						green = 255;
						blue = 1275 - temp;
					} else 	if (temp <= 1020 && temp > 765) { // red toward cyan
						red = 1020 - temp;
						green = temp - 765;
						blue = temp - 765;
					} else 	if (temp <= 765 && temp > 510) { // green toward red
						red = temp - 510;
						green = 765 - temp;
						blue = 0;
					} else 	if (temp <= 510 && temp > 255) { // maj toward green
						red = 510 - temp;
						green = temp - 255;
						blue = 510 - temp;
					} else { //  blue toward maj
						red = temp;
						green = 0;
						blue = 255;
					}
					// Add to array
					data[(j * width) + i]= (red << 16) | (green << 8) | (blue);
				}
			}
		}

		// build the image
		image= new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		image.setRGB(0,0,width,height,data,0,width);
		repaint();
	}


	/**
	 * getWidth overides JComponent
	*/
	public int getWidth() {
		return table.length;
	}

	/**
	 * getHeight overides JComponent
	*/
	public int getHeight() {
		return table[0].length;
	}

	/**
	 * exisiting color display
	* returns 0 if grayscale, returns 1 if color
	*/
	public boolean isColor() {
		return is_color;
	}

	/**
	 * paint
	*/
	public void paint(Graphics g) {
		g.drawImage(image,0,0,this);
	}

	/**
	 * implementation of Scrollable interface
	*   the following 5 methods deal with the Scrollable interface
	*/
	public Dimension getPreferredScrollableViewportSize() {
		return getPreferredSize();
	}

	/**
	 * Components that display logical rows or columns should compute
	*   the scroll increment that will completely expose one new row or
	*   column, depending on the value of orientation.
	*/
	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
		return 1;
	}

	/**
	 * Components that display logical rows or columns should compute
	*   the scroll increment that will completely expose one block of
	*   rows or columns, depending on the value of orientation.
	*/
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
		return 10;
	}

	/**
	 *  Return true if a viewport should always force the width of
	*    this Scrollable to match the width of the viewport.
	*/
	public boolean getScrollableTracksViewportWidth() {
		return false;
	}

	/**
	 *  Return true if a viewport should always force the height of
	*    this Scrollable to match the height of the viewport.
	*/
	public boolean getScrollableTracksViewportHeight() {
		return false;
	}

	/**
	*  Returns a reference to the current BufferedImage object that is being drawn
	* on this JPanel. This is useful for external imaging.
	* @see java.awt.image.BufferedImage
	* @since 1.0.3
	*/
	public BufferedImage getBufferedImage() {
		return image;
	}

	/**
	 * overrides java.lang.Object.toString()
	*/
	public String toString() {
		return this.getClass().getName() + C5DemConstants.copy;
	}
}
