package com.c5corp.c5viewUi;

/**
* This class extends the abstract class javax.swing.filechooser.FileFilter
* it is used to filter .dem and .DEM extensions in the JFileChooser
* It also implements the same logic as a java.io.FileFilter.
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0
* @see java.io.FileFilter
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

import java.io.*;

public class DemFileFilter extends javax.swing.filechooser.FileFilter
		implements java.io.FileFilter {

    /**
     * Constructor
     */
	public DemFileFilter() {
		super();
	}

   /**
    * Overrides javax.swing.filechooser.FileFilter.accept(File f) to specify the file
    *   filter for the JFileChooser
    */
	public boolean FileFilteraccept(File f) {
		if (f.toString().toLowerCase().endsWith(".dem") || f.isDirectory()) {
			return true;
		} else {
			return false;
		}
	}

   /**
    * implements java.io.FileFilter.accept(File f) to specify the file
    *  filter
    */
	public boolean accept(File f) {
		return FileFilteraccept(f);
	}

   /**
    * description of the file types
    */
	public String getDescription() {
		return "*.dem, *.DEM";
	}
}
