package com.c5corp.c5viewUi;

/**
* This class extends the implements java.io.FilenameFilter
* It is used to filter .class files in the com.c5corp.DEMconvert.filters package
* for dynamic class loading.
* @author Brett Stalbaum copyright 2002-2005
* @see java.io.FilenameFilter
* @version 1.0.3
* @since 1.0
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

import java.io.*;

class ClassFileFilter implements FilenameFilter {

   /**
    * Constructor
    */
	ClassFileFilter() {
	}

   /**
    * implements FilenameFilter.accept(File f) to specify the file
    *   filter for the JFileChooser
    */
	public boolean accept(File dir, String name) {
		if (name.toLowerCase().endsWith(".class")) {
			return true;
		} else {
			return false;
		}
	}
}