package com.c5corp.c5utm.util;

/** <code>public class VerifyDb</code>
* VerifyDb.java - part of Landscape database (otherwise known as the C5UTM database).
* This simple class implements a commanline utility creates a C5UTMconfs object to
* test the C5UTM database installation. verifydb uses a C5UTMconfs object to provide a commandline
* tool to check the status of the C5UTM database and verify that
* it is running.
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

import com.c5corp.c5utm.*;

public final class VerifyDb {
	public static void main(String[] args) {
		C5UTMconfs conf = new C5UTMconfs();
		String usage = "usage: verifydb -i (database info) or -c (check database)";
		if (args.length == 1) {
			if (args[0].equals("-i")) {
				System.out.println("Database info:");
				System.out.println("JDBC database URL: " + conf.getDbUrl());
				System.out.println("JDBC database driver: " + conf.getDriver());
				System.out.println("Access password: " + conf.getAccessPassword());
				System.out.println("Update password: " + conf.getUpdatePassword());
				System.out.println("Database verified: " + new Boolean(conf.databaseWorking()).toString());
				System.out.println("Database units configured: " + new Boolean(conf.databaseUnitsConfigured()).toString());
				System.out.println();
				System.out.println("Local units configuration:");
				System.out.println("Vertical datum: " + conf.getVerticalDatum());
				System.out.println("Horizontal datum: " + conf.getHorizontalDatum());
				System.out.println("Vertical units: " + conf.getVerticalUnits());
				System.out.println("Horizontal units: " + conf.getHorizontalUnits());
				System.out.println();
				System.out.println("C5UTM directories:");
				System.out.println("CORPSCON: " + conf.getCorpsconDir());
				System.out.println("DEM: " + conf.getDemDir());
				System.out.println("RECEIPTS: " + conf.getReceiptsDir());
				System.out.println("NEW_DEMS: " + conf.getNewDemsDir());
				System.out.println();
				System.out.println("C5UTM base url:");
				System.out.println("base url for this install: " + conf.getBaseUrl());
			} else if (args[0].equals("-c")) {
				System.out.print(conf.getMessages());
			} else {
				System.err.println(usage);
			}
		} else {
			System.err.println(usage);
		}
	}
}
