package com.c5corp.c5utm.util;

/** <p>This convienence class calls Build1KGridFromFiles.Build1KGridFromFiles();
* and Build1KGridFromDb.Build1KGridFromDb() in this order.</p>
* This is generally a smart order in which to call these utilities, because
* it can be much faster to build the 1K grid data and images from files first, (Build1KGridFromFiles)
* followed by stitching and infilling the unfilled edges utilizing the UTM_COORDS data in the database,
* which is what Build1KGridFromDb does if the 1K_grid data attribute of DEM_METADATA is already
* set to 1. However, Build1KGridFromDb will process an entire dem area if asked to (assuming that
* 1K_grid is set to 0). For some applications, such as super computing, this might be a better option.</p>
* @see Build1KGridFromFiles
* @see Build1KGridFromDb
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0.3
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public class Build1KGridStats {
	/** Run from the command line */
	public static void main (String[] args) {
		try {
			boolean verbose = false;
			if (args[0] != null && args[0].equals("true")) {
				verbose = true;
			}
			// try to process all the 0 level DEM_METADATAs with Build1KGridFromFiles
			Build1KGridFromFiles.Build1KGrid(verbose);
			// try to process all 0 and 1 level DEM_METADATAs with Build1KGridFromDb
			Build1KGridFromDb.Build1KGrid(verbose);
		} catch (ArrayIndexOutOfBoundsException e) {
			System.err.println("usage: Build1KGridStats [true|false]");
			System.err.println("(\"true\" turns on verbose mode)");
			e.printStackTrace(); // sometimes a real ArrayIndexOutOfBoundsException will be
								// coughed out somewhere...
		}
	}
}
