package com.c5corp.c5utm.util;

/**
* <p>Build1KGridFromFiles builds the 1K_GRID_STATS table
* from the dem files stored in the configured DEM directory &&
* the corresponding records in the database's UTM_METADATA table. (It required that both exist.)
* (The actual records are stored in then UTM_POINT_STATS table.)
* Building this data from data in files is generally faster than going to the database.
* This program is executed by the Build1KGridStats utility,
* which will try to use it intelligently by examining UTM_METADATA.1K_grid attribute. It
* uses the com.c5corp.DEMconvert.filters.Dem2C51KGrid</p>
* @see Build1KGridStats
* @see com.c5corp.DEMconvert.filters.Dem2C51KGrid
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0.3
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

import java.io.File;
import com.c5corp.c5utm.*;
import com.c5corp.c5viewUi.DemFileFilter;
import com.c5corp.DEMconvert.filters.Dem2C51KGrid;

public class Build1KGridFromFiles {

	public static void Build1KGrid() {

		// get a list of the filenames in NEW_DEMS that must be added
		C5UTMconfs confs = new C5UTMconfs();
		File[] fileNames = null;
		File file = confs.getDemDirFile();
		if (file.isDirectory()) {
			fileNames = file.listFiles(new DemFileFilter());
		}

		// run Dem2C51KGrid over those files
		for (int i = 0; i < fileNames.length; i++) {
			new Dem2C51KGrid(fileNames[i].toString());
		}
	}
	
	public static void Build1KGrid(boolean verbose) {
		
		if (verbose) {
			System.out.println("Build1KGridFromFiles executed....");
		}

		// get a list of the filenames in NEW_DEMS that must be added
		C5UTMconfs confs = new C5UTMconfs();
		File[] fileNames = null;
		File file = confs.getDemDirFile();
		if (file.isDirectory()) {
			fileNames = file.listFiles(new DemFileFilter());
		}

		// run Dem2C51KGrid over those files
		for (int i = 0; i < fileNames.length; i++) {
			if (verbose) {
				System.out.println(
					"Trying to process " + 
					fileNames[i].toString() + 
					" to level 1 in DEM_METADATA.1KGrid"
				);
			}
			new Dem2C51KGrid(fileNames[i].toString());
			if (verbose) {
				System.out.println(
						fileNames[i].toString() + " processing complete."
				);
			}
		}
	}

	/** Run from the command line */
	public static void main (String[] args) {
		Build1KGrid
		();
	}

}
