package com.c5corp.c5utm.util;

/** <code></code>
* <p>BatchAddDems is a java utility that runs the Dem2C5UTM filter over all the DEM files
* stored in the NEW_DEMS directory. When processed, it moves the newly aquired dem from NEW_DEMS to DEM.
* The locations of the directories are the c5utm home dir, but can also be configured in c5utm/conf
* and accessed via a C5UTMconfs object.</p>
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0.3
* @see com.c5corp.DEMconvert.filters.Dem2C5UTM
* @see com.c5corp.c5utm.C5UTMconfs
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

import java.io.*;
import com.c5corp.c5viewUi.*;
import com.c5corp.c5utm.*;
import java.util.Date;
import com.c5corp.DEMconvert.filters.*;

public class BatchAddDems {

	/** Adds all of the DEM files in the configured NEW_DEMS directory to
	* the database. When a DEM file is successfully added, it is moved to the
	* configured DEM directory
	*/
	public static void batchAddDems() {

		File newDems = null; // NEW_DEMS dir
		File summaryFile = null; // BATCH_SUMMARY file
		File[] files = null;
		DemFileFilter filter = new DemFileFilter();
		C5UTMconfs confs = new C5UTMconfs();
		String summaryStr = null;
		String receiptStr = null;
		//File receipt = null;
		BufferedReader in = null;
		String receiptData = null;
		// set up the summary file writer
		FileWriter writer = null;

		System.out.println("BatchAddDems is a utility that runs the Dem2C5UTM filter " +
			"over all of the DEM files stored in the NEW_DEMS directory. " +
			"When processed, it moves the newly aquired dem " +
			"from the NEW_DEMS directory to the DEM directory.");

		// get a list of the filenames in NEW_DEMS that must be added
		newDems = new File(confs.getNewDemsDir()); // get the configured NEW_DEMS dir)
		files = newDems.listFiles(filter);

		// make a timestamp for the file name, and File ob
		summaryStr = (new Date()).toString();
		summaryStr = summaryStr.replace(' ', '_');
		summaryStr = summaryStr.replace(':', '_');
		summaryStr = summaryStr + "_batch.sum";
		summaryFile = new File(confs.getReceiptsDir() + File.separatorChar + summaryStr);

		try {
			writer = new FileWriter(summaryFile);
		} catch (IOException e) {
			System.err.println(e);
			System.exit(1);
		}

		for (int i=0; i < files.length; i++) {
			System.out.println("-------------------------------------\n");
			System.out.println("processing: " + files[i]);

			// process the file (add to db)
			String[] args = new String[2];
			args[0] = "-i";
			args[1] = files[i].toString();
			Dem2C5UTM.main(args);

			// check the results
			// form the receipt file name
			receiptStr = args[1].replaceFirst(confs.getNewDemsDir(), confs.getReceiptsDir());
			receiptStr = receiptStr.replaceFirst(".dem", ".dat");
			// open the RECEIPT file
			//receipt = new File(receiptStr);

			// try to read the file that was just created
			try {
				in = new BufferedReader(new FileReader(receiptStr));
			} catch (FileNotFoundException e) {
				System.err.println(e);
				System.err.println("This file should always be created when adding dem files to C5UTM...");
			}

			try {
				// priming read
				receiptData = in.readLine();
				// iterate over file contents looking for OK
				while (receiptData != null) {
					if (receiptData.matches(".*File added to C5UTM with success.*")) {
						System.out.println("moving " + args[1] + " to " + confs.getDemDir() + "\n");

						// move the dem file
						// - having trouble with File.renameTo... it does not work on Windows XP
						// always returns false... using streams to move the file
						boolean moved = false;
						files[i] = files[i].getAbsoluteFile();
						File newFile = new File(args[1].replaceFirst(confs.getNewDemsDir(), confs.getDemDir()));
						newFile = newFile.getAbsoluteFile();
						// copy the original dem to the new location
						BufferedReader demin = new BufferedReader(new FileReader(files[i]));
						newFile.delete(); // make sure the new file does not exist before we write it
						FileWriter demwrite = new FileWriter(newFile);
						String temp = demin.readLine();
						while (temp != null) {
							demwrite.write(temp);
							temp = demin.readLine();
							moved = true;
						}
						demwrite.flush();
						demwrite.close();
						demin.close();

						// delete the old file
						files[i].delete();

						//moved = files[i].renameTo(newFile);

						// update the summary log
						Date date = new Date();

						// if ok in the receipt file, the file was added
						System.out.println(args[1] + " added OK at " + date);
						writer.write(args[1] + " added OK at " + date + "\n");

						// confirm the file was moved
						if (moved) {
							System.out.println(args[1] + " moved OK at " + date);
							writer.write(args[1] + " moved OK at " + date + "\n");
						} else {
							System.err.println("Unable to move dem file " + args[1] + " from " + confs.getNewDemsDir() +
							" to " + confs.getDemDir() + " at " + date + ".");
							writer.write("Unable to move dem file " + args[1] + " from " + confs.getNewDemsDir() +
							" to " + confs.getDemDir() + " at " + date + ".\n");
						}

						in.close();
						break;
					}
					receiptData = in.readLine();
				}

			} catch (IOException e) {
				System.err.println(e);
			}
		}

		try {
			writer.flush();
			writer.close();
		} catch (IOException e) {
			System.err.println(e);
		}
	}

	/** Run from the command line */
	public static void main(String args[]) {
		batchAddDems();
	}
}
