package com.c5corp.c5utm;

/**
* <code>public class Point</code>
* Point.java - part of Landscape database (otherwise known as the C5UTM
* database). A <code>Point</code> is just a structure to hold the
* fields from a UTM_COORDS record. It provides constructor and accessor
* methods for all fields. Usually you will not create and instance
* of this class yourself, but will use the static methods in the C5UTM class
* class to create a Point from a query of some sort. If you do encounter
* "Artifical" points, it is likely to be mediated by the ArtificialPoints
* class. This class also provides a toString() method.
* Clean up this docu! (See sql for doc on params...)
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0.3
* @see Points
* @see ArtificialPoints
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

import com.c5corp.c5dem.UtmCoordinatePairElev;

public class Point {
	private byte zone;
	private int easting;
	private int northing;
	private short elevation;
	private String dem_id;
	private String id;


	/**
	* Default constructor for the Point class
	*/
	public Point() {
	}

	/**
	* Constructor for the Point class. Normally you would not call this constructor yourself, but
	* would use on of the static methods fo the C5UTM class to create an object of this type.
	* The static methods of the C5UTM class makes an call to the database in which the
	* related data from the UTM_COORDS table is taken and an instance of this class produced.
	*/
	public Point(int zone, int easting, int northing, int elevation, String dem_id, String id) {
		this.zone=(byte)zone;
		this.easting=easting;
		this.northing=northing;
		this.elevation=(short)elevation;
		this.dem_id=dem_id;
		this.id=id;
	}

	/**
	* Constructor for the Point class which constructs a Point from a UTM zone and a
	* com.c5corp.c5dem.UtmCoordinatePairElev
	* object. Such an object will have empty strings as the values for dem_id and id. (In other words,
	* it will contain no reference to the records in relational database.)
	*/
	public Point(int zone, UtmCoordinatePairElev point) {
		this.zone=(byte)zone;
		this.easting=point.getEasting();
		this.northing=point.getNorthing();
		this.elevation=(short)point.getElevation();
		dem_id="";
		id="";
	}

	/** <code>public getZone()</code> accesses the zone member */
	public int getZone() {
		return (int)zone;
	}

	/** <code>public getEasting()</code> accesses the easting member */
	public int getEasting() {
		return easting;
	}

	/** <code>public getNorthing()</code> accesses the northing member */
	public int getNorthing() {
		return northing;
	}

	/** <code>public getElevation()</code> accesses the elevation member */
	public int getElevation() {
		return (int)elevation;
	}

	/** <code>public getDemId()</code> accesses the elevation member */
	public String getDemId() {
		return dem_id;
	}

	/** <code>public getId()</code> accesses the id member */
	public String getId() {
		return id;
	}

	/** overrides toString() of the Object class */
	public String toString() {
		return 	"zone = " +  zone + "\n" +
			"easting = " + easting + "\n" +
			"northing = " + northing + "\n" +
			"elevation = " + elevation + "\n" +
			"dem_id = " + dem_id + "\n" +
			"id = " + id+ "\n";
	}
}
