package com.c5corp.c5utm;

import java.sql.*;

/** <code>public class DbHelper</code>
* DbHelper.java - part of Landscape database (otherwise known as the C5UTM database).
* This class provides a single static method,
* <code>protected static Connection getDbConnection()</code> that can be used to get a
* java.sql.Connection object to the C5UTM database. This connection is for access (select)
* only.
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0.3
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public class DbHelper {

	/** <code>protected static Connection getDbConnection()</code> helps get a db connection*/
	//there is a technical issue I have to sort out. I'd like this class
	// to work with C5UTMconfs class. But it is really only designed
	// to allow a local installation to look up stuff like db url and passwords
	// on a localhost installation - aka the mysql server runs on the same box
	// as the web server. But this conflicts with configuring mysql to run
	// on a different machine alltogether! So for now, I am hard coding username
	// and password info here... until I can accomodate a conf file that can
	// be configured in some good way on either type of install and still work right.
	public static Connection getDbConnection() {

		Connection connection;
		C5UTMconfs confs = new C5UTMconfs();

		try{

			//System.out.println(confs.getMessages());
			//System.out.println(confs.getDriver());
			//Class.forName(confs.getDriver());
			Class.forName("com.mysql.jdbc.Driver");
			System.out.println("opening DB connection");

			String dbURL = confs.getDbUrl();
			String username = "C5UTM_access";
			String password = confs.getAccessPassword();
			connection = DriverManager.getConnection(dbURL, username, password);
		} catch(ClassNotFoundException e){
			System.err.println("Database driver not found.");
			return null;
		} catch(SQLException e){
			System.err.println("Error opening the db connection: "
				+ e.getMessage());
			return null;
		}

		return connection;
	}


	/** helps get a db connection*/
	//there is a technical issue I have to sort out. I'd like this class
	// to work with C5UTMconfs class. But it is really only designed
	// to allow a local installation to look up stuff like db url and passwords
	// on a localhost installation - aka the mysql server runs on the same box
	// as the web server. But this conflicts with configuring mysql to run
	// on a different machine alltogether! So for now, I am hard coding username
	// and password info here... until I can accomodate a conf file that can
	// be configured in some good way on either type of install and still work right.
	public static Connection getDbConnection(String path) {

		Connection connection;
		C5UTMconfs confs = new C5UTMconfs(path);

		try{

			//System.out.println(confs.getMessages());
			//System.out.println(confs.getDriver());
			//Class.forName(confs.getDriver());
			Class.forName("com.mysql.jdbc.Driver");
			//System.out.println("opening DB connection");

			String dbURL = confs.getDbUrl();
			String username = "C5UTM_access";
			String password = confs.getAccessPassword();
			connection = DriverManager.getConnection(dbURL, username, password);
		} catch(ClassNotFoundException e){
			System.err.println("Database driver not found.");
			return null;
		} catch(SQLException e){
			System.err.println("Error opening the db connection: "
				+ e.getMessage());
			return null;
		}

		return connection;
	}

	/** Tidys up the db connection. */
	public static void closeDbConnection(Connection connection) {
		//System.out.println("close DB connection");
		try{
			connection.close();
		} catch(SQLException e){
			System.err.println("Error closing the db connection: "
				+ e.getMessage());
		}
	}
}
