package com.c5corp.c5utm;

import java.sql.*;
import java.util.*;

/** <code>public class C5UTMdatabaseMethods</code>
* C5UTMdatabaseMethods.java - part of the C5 Landscape Landscape database (otherwise known as the C5UTM database).
* Contains static methods to access data in a C5UTM database.
* It somewhat duplicates methods available in C5UTM.java (which mirrors the functionality
* of the C5UTM.pm - the orginal perl module from which C5UTM.java was inspired.) All methods
* originaly developed as part of this class (from the java trajectory of the project development)
* have now been moved to C5UTM.java.
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0
* @deprecated This class is deprecated since version 1.0.3, and all of its functionality moved to the C5UTM class.
* @see com.c5corp.c5utm.C5UTM
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public class C5UTMdatabaseMethods {

	/** <code>Vector findExactDemNames(String str, C5UTMconfs conf)</code>
	* Finds an exact match for a dem name from the file_info field of DEM_METADATA.
	* This method will normally return a Vector with either 0 or 1 element
	* of type String. If it returns more elements, you may wish to investigate
	* that there is not a duplicate map in the database. If you have a confs
	* object available, use this version. It is faster not to make a new C5UTMconfs.
	* @deprecated This method is deprecated, moved to the C5UTM class.
	* @see com.c5corp.c5utm.C5UTM
	*/
	public static Vector findExactDemNames(String str, C5UTMconfs confs) {
		Vector<DemMetadata> vec = new Vector<DemMetadata>();
		try {

			Connection connection=DriverManager.getConnection(confs.getDbUrl(),
				"C5UTM_access", confs.getAccessPassword());
			Statement select = connection.createStatement();
			ResultSet result = select.executeQuery
				("SELECT * FROM DEM_METADATA where file_info LIKE '" + str + "'");

			while (result.next()) {
				vec.add(new DemMetadata(
						result.getString("DEM_METADATA_id"),
						result.getInt("zone"),
						result.getInt("columns_x"),
						result.getInt("max_profile_length_y"),
						result.getDouble("sw_easting"),
						result.getDouble("sw_northing"),
						result.getDouble("nw_easting"),
						result.getDouble("nw_northing"),
						result.getDouble("ne_easting"),
						result.getDouble("ne_northing"),
						result.getDouble("se_easting"),
						result.getDouble("se_northing"),
						result.getDate("date_added"),
						result.getString("local_dem_file"),
						result.getString("file_info"),
						result.getInt("1K_grid"),
						result.getInt("point_stats"),
						result.getInt("average_elevation")
					)
				);
			}
			select.close();
			connection.close();     // close db connection
		} catch (SQLException e) {
			System.out.println("Exception when checking for pre-existing entry.");
			e.printStackTrace();
		}
		return vec;
	}

	/** <code>Vector findExactDemNames(String str)</code>
	* Finds an exact match for a dem name from the file_info field of DEM_METADATA.
	* This method will normally return a Vector with either 0 or 1 element
	* of type String. If it returns more elements, you may wish to investigate
	* that there is not a duplicate map in the database. If you have a confs
	* object available, use <code>Vector findLikeDemNames(String str, C5UTMconfs conf)</code>
	* This overloaded version is slower because it has the overhead of making a new C5UTMconfs
	* @deprecated This method is deprecated, moved to the C5UTM class.
	* @see com.c5corp.c5utm.C5UTM
	*/
	public static Vector findExactDemNames(String str) {
		C5UTMconfs confs = new C5UTMconfs();
		return findExactDemNames(str, confs);
	}

	/** <code>Vector findDemNameContains(String str, C5UTMconfs conf)</code>
	* This method will normally return a Vector with either 0 or more elements
	* of type String. It searches the file_info field of DEM_METADATA for a
	* subsring containing the query string. If you have a confs
	* object available, use this version. It is faster not to make a new C5UTMconfs.
	* @deprecated This method is deprecated, its functionality replaced by the
	* <code>getDemMetadata(String query)</code> method of the C5UTM class.
	* @deprecated This method is deprecated, moved to the C5UTM class.
	* @see com.c5corp.c5utm.C5UTM
	*/
	public static Vector findDemNameContains(String str, C5UTMconfs confs) {
		Vector<DemMetadata> vec = new Vector<DemMetadata>();
		try {

			Connection connection=DriverManager.getConnection(confs.getDbUrl(),
				"C5UTM_access", confs.getAccessPassword());
			Statement select = connection.createStatement();
			ResultSet result = select.executeQuery
				("SELECT * FROM DEM_METADATA where file_info LIKE '%" + str + "%'");

			while (result.next()) {
				vec.add(new DemMetadata(
						result.getString("DEM_METADATA_id"),
						result.getInt("zone"),
						result.getInt("columns_x"),
						result.getInt("max_profile_length_y"),
						result.getDouble("sw_easting"),
						result.getDouble("sw_northing"),
						result.getDouble("nw_easting"),
						result.getDouble("nw_northing"),
						result.getDouble("ne_easting"),
						result.getDouble("ne_northing"),
						result.getDouble("se_easting"),
						result.getDouble("se_northing"),
						result.getDate("date_added"),
						result.getString("local_dem_file"),
						result.getString("file_info"),
						result.getInt("1K_grid"),
						result.getInt("point_stats"),
						result.getInt("average_elevation")
					)
				);
			}

			select.close();
			connection.close();     // close db connection

		} catch (SQLException e) {
			System.err.println("Exception when checking for pre-existing entry.");
			e.printStackTrace();
		}
		return vec;
	}

	/** <code>Vector findDemNameContains(String str)</code>
	* This method will normally return a Vector with either 0 or 1 element
	* of type String. This method will normally return a Vector with eiter 0 or more elements
	* of type String. It searches the file_info field of DEM_METADATA for a
	* subsring containing the query string. If you have a confs
	* object available, use <code>Vector findDemNameContains(String str, C5UTMconfs conf)</code>
	* This overloaded version is slower because it has the overhead of making a new C5UTMconfs.
	* @deprecated This method is deprecated, has beem moved to the C5UTM class.
	* @see com.c5corp.c5utm.C5UTM
	*/
	public static Vector findDemNameContains(String str) {
		C5UTMconfs confs = new C5UTMconfs();
		return findDemNameContains(str, confs);
	}

	/** <code>boolean deleteDem(String id, C5UTMconfs conf)</code>
	* This method drops a dem from the database according to its id. The id can be found
	* in the RECEIPT folder. Also deletes the receipt file.
	* @deprecated This method is deprecated, moved to the C5UTM class.
	* @see com.c5corp.c5utm.C5UTM
	*/
	public static String deleteDem(String id, C5UTMconfs confs) {
		int meta_data_result = -1;
		int coords_result = -1;

		// delete DEM_METADATA record
		try {

			Connection connection=DriverManager.getConnection(confs.getDbUrl(),
				"C5UTM_update", confs.getUpdatePassword());
			Statement s = connection.createStatement();
			meta_data_result = s.executeUpdate
				("DELETE FROM DEM_METADATA where DEM_METADATA_id=" + id);

			s.close();
			connection.close();     // close db connection

		} catch (SQLException e) {
			System.out.println("Exception when trying to delete dem id " + id + " from DEM_METADATA");
			e.printStackTrace();
		}

		// delete UTM_Coords records
		try {

			Connection connection=DriverManager.getConnection(confs.getDbUrl(),
				"C5UTM_update", confs.getUpdatePassword());
			Statement s = connection.createStatement();
			coords_result = s.executeUpdate
				("DELETE FROM UTM_COORD where DEM_METADATA_id=" + id);

			s.close();
			connection.close();     // close db connection

		} catch (SQLException e) {
			System.out.println("Exception when trying to drop dem id " + id + " from UTM_COORD");
			e.printStackTrace();
		}


		return "Deleted DEM_METADATA_id " + id + ", " + meta_data_result + " DEM_METADATA record and "
			+ coords_result + " UTM_COORD records.";
	}

	/** <code>boolean deleteDem(String id)</code>
	* This method drops a dem from the database according to its id. The id can be found
	* in the RECEIPT folder. Also deletes the receipt file. If you have a confs
	* object available, use <code>boolean dropDem(int id, C5UTMconfs conf)</code>
	* This overloaded version is slower because it has the overhead of making a new C5UTMconfs.
	* @deprecated This method is deprecated, moved to the C5UTM class.
	* @see com.c5corp.c5utm.C5UTM
	*/
	public static String deleteDem(String id) {
		C5UTMconfs confs = new C5UTMconfs();
		return deleteDem (id, confs);
	}
}
