package com.c5corp.c5dem;

/**
* <p>UTM coordinates pair model with elevations</p>
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public class UtmCoordinatePairElev extends UtmCoordinatePair {

	////////////////
	//DECLARATIONS//
	////////////////

	private int elevation;

	////////////////
	//CONSTRUCTORS//
	////////////////

	/** Constructor for a UtmCoordinatePairElev object.
	* @param easting the UTM easting
	* @param northing the UTM northing
	* @param elevation the elevation value
	* @see com.c5corp.c5utm.C5UTMconfs
	*/
	public UtmCoordinatePairElev(int easting, int northing, int elevation) {
		super(easting, northing);
		this.elevation=elevation;
	}

	///////////
	//METHODS//
	///////////

	/** Returns the elevation of the UTM coordinates.*/
	public int getElevation() {
		return elevation;
	}

	/** Overrides java.lang.Object.toString()*/
	public String toString() {
		return new String("easting: " + getEasting() +
			" northing: " + getNorthing() + " elevation: " + elevation);
	}
}
