package com.c5corp.c5dem;

/**
* <p>UTM coordinates pair model that maintains double precision for
* coords with fractional parts. The coordinate corners (record 11
* in the Type A record), are more precise than the typical UTM coords in
* the Type b record. (they have a decimal part...) This class is
* intended for those records. It is not actually related to the
* UtmCoordinatePair class.</p>
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public class PreciseUTMcoordPair {

	////////////////
	//DECLARATIONS//
	////////////////

	private double easting;
	private double northing;

	////////////////
	//CONSTRUCTORS//
	////////////////

	/** Constructor for a UTM PreciseUTMcoordPair object.*/
	PreciseUTMcoordPair(int easting, int northing) {
		this.easting=(double)easting;
		this.northing=(double)northing;
	}

	/** Constructor for a UTM PreciseUTMcoordPair object.*/
	PreciseUTMcoordPair(double easting, double northing) {
		this.easting=easting;
		this.northing=northing;
	}

	///////////
	//METHODS//
	///////////

	/** Returns the UTM easting value*/
	public double getEasting() {
		return easting;
	}

	/** Returns the UTM northing value*/
	public double getNorthing() {
		return northing;
	}

	/** Overrides java.lang.Object.toString()*/
	public String toString() {
		return new String("easting: " + easting + " northing: " + northing);
	}
}
