package com.c5corp.c5dem;

/**
* <p>Interface C5DemConstants contains final vars used in various places throughout c5dem
* and related packages</p>
* @author Brett Stalbaum copyright 2002-2005
* @version 1.0.3
* @since 1.0
*/

/*
* This library is free software; you can redistribute it and/or modify it under the
* terms of the GNU Lesser General Public License as published by the Free Software
* Foundation; either version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License along with this
* library; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
* Please refer to LICENSE.txt which is distributed with the distribution for the
* full text of the GNU Lesser General Public License
*/

public interface C5DemConstants {

	/** <code>public final String[] system<code> defines the ground planimetric reference system,
			data element 5 in the dem specification. 0=Geographic, 1=UTM, 2=State plane.
				Code 0 represents the geographic (latitude/longitude) system for
				30-minute, 1-degree and Alaska DEM's.
				Code 1 represents the current use of the UTM coordinate system
				for 7.5-minute DEM's. (Pretty much all contemporary dems...)
			@see com.c5corp.c5dem.Dem#get_planimetric_system
	*/
	public final String[] system = {"geographic","UTM","State Plane"};

	/** public final String[] units containns the values "feet","meters","arc seconds". These
			are the horizontal units specified in the Dem specification. For example, if the horizontal unit
			is equal to 1, then the dem file horizontal unit is meters. units[1] is also equal to meters,
			which is useful for comparison.
			@see com.c5corp.c5dem.Dem#get_planimetric_unit
	*/
	public final String[] units = {"feet","meters","arc seconds"};

	/** public final String[] vdatum containts the values "mean sea level", "NGVD29", "NAVD88".
			These are various vertical datums
			that might be found in dem files. These are in the order of the dem specification,
			but 0 based. Thus if the vertical datum element in a dem (Element 26) is equal to 2,
			it is a NGVD29 file, and hdatam[1] (horizontal datum -1) equals NGVD29, which is useful for comparison.
			@see com.c5corp.c5dem.Dem#get_vertical_datum
	*/
	public final String[] vdatum = {"mean sea level", "NGVD29", "NAVD88"};

	/** public final String[] hdatum contains the values "NAD27","WGS72","WGS84","NAD83",
			"OLD Hawaii","Puerto Rico","NAD83 provisional". These are various horizontal datums
			that might be found in dem files. These are in the order of the dem specification,
			but 0 based. Thus if the horizontal datum element in a dem (Element 27) is equal to 1,
			it is a NAD27 file, hdatam[0] (horizontal datum -1) equals NAD27, which is useful for comparison.
			@see com.c5corp.c5dem.Dem#get_horizontal_datum
	*/
	public final String[] hdatum = {"NAD27","WGS72","WGS84","NAD83",
		"OLD Hawaii","Puerto Rico","NAD83 provisional"};

	/** public final String copy contains copyright information*/
	public final String copy = "\nC5 Landscape Database 1.0.3, (c)2002-2005 C5 corp, www.c5corp.com\nTerms of GNU Lesser General Public License";

	/** public final double METERSTOFEET = 3.28084;<br>
		Constant value for converting meters to feet.
		One meter 3.2808 feet
	*/
	public final double METERSTOFEET = 3.2808399; // one meter 3.2808399 feet

	/** public final double FEETTOMETERS = 0.3048;<br>
		Constant value for converting meters to feet<br>
		One foot 0.3048 meters
	*/
	public final double FEETTOMETERS = 0.3048; // one foot 0.3048 meters

	// Bit masks for use in a variety of different C5UTM classes.
	// Bit order: NW,  W, SW, S, SE, E, NE, N
	// Bit order: 128,64, 32, 16, 8, 4,  2, 1
	//
	/** Constant representing and mask for NW bit*/
	public final static int NW_BIT = 128;
	/** Constant representing and mask for W bit*/
	public final static int W_BIT = 64;
	/** Constant representing and mask for SW bit*/
	public final static int SW_BIT = 32;
	/** Constant representing and mask for S bit*/
	public final static int S_BIT = 16;
	/** Constant representing and mask for SE bit*/
	public final static int SE_BIT = 8;
	/** Constant representing and mask for E bit*/
	public final static int E_BIT = 4;
	/** Constant representing and mask for NE bit*/
	public final static int NE_BIT = 2;
	/** Constant representing and mask for N bit*/
	public final static int N_BIT = 1;
}

