/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.OSGB_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class OSGB_To_Gdc_Converter {
    static final double DEGREES_PER_RADIAN = 57.29577951308232;
    static double Origin_lon = -2.0;
    static double Origin_lat = 49.0;
    static double X0 = 400000.0;
    static double Y0 = -100000.0;
    static double K0 = 0.9996012717;
    static double a;
    static double f;
    static double b;
    static double Eps2;
    static double e1;
    static double EE2;
    static double EE3;
    static double Epps2;

    public static void Init(double d, double d2) {
        OSGB_To_Gdc_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        OSGB_To_Gdc_Converter.CreateConstants(6377563.396, 299.3249646);
    }

    public static void Init(Ellipsoid ellipsoid) {
        OSGB_To_Gdc_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        a = d;
        f = 1.0 / d2;
        b = a * (1.0 - f);
        Eps2 = f * (2.0 - f);
        e1 = (1.0 - Math.sqrt(1.0 - Eps2)) / (1.0 + Math.sqrt(1.0 - Eps2));
        EE2 = Eps2 * Eps2;
        EE3 = EE2 * Eps2;
        Epps2 = Eps2 / (1.0 - Eps2);
        Origin_lat /= 57.29577951308232;
        Origin_lon /= 57.29577951308232;
    }

    public static void Convert(OSGB_Coord_3d oSGB_Coord_3d, Gdc_Coord_3d gdc_Coord_3d) {
        OSGB_Coord_3d[] oSGB_Coord_3dArray = new OSGB_Coord_3d[1];
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        oSGB_Coord_3dArray[0] = oSGB_Coord_3d;
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        OSGB_To_Gdc_Converter.Convert(oSGB_Coord_3dArray, gdc_Coord_3dArray);
    }

    public static void Convert(OSGB_Coord_3d[] oSGB_Coord_3dArray, Gdc_Coord_3d[] gdc_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            gdc_Coord_3dArray[n].elevation = oSGB_Coord_3dArray[n].z;
            double d = oSGB_Coord_3dArray[n].x - X0;
            double d2 = oSGB_Coord_3dArray[n].y - Y0;
            double d3 = a * ((1.0 - Eps2 / 4.0 - 3.0 * EE2 / 64.0 - 5.0 * EE3 / 256.0) * Origin_lat - (3.0 * Eps2 / 8.0 + 3.0 * EE2 / 32.0 + 45.0 * EE3 / 1024.0) * Math.sin(2.0 * Origin_lat) + (15.0 * EE2 / 256.0 + 45.0 * EE3 / 1024.0) * Math.sin(4.0 * Origin_lat) - 35.0 * EE3 / 3072.0 * Math.sin(6.0 * Origin_lat));
            double d4 = d3 + d2 / K0;
            double d5 = d4 / (a * (1.0 - Eps2 / 4.0 - 3.0 * EE2 / 64.0 - 5.0 * EE3 / 256.0));
            double d6 = d5 + (3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0) * Math.sin(2.0 * d5) + (21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0) * Math.sin(4.0 * d5) + 151.0 * e1 * e1 * e1 / 96.0 * Math.sin(6.0 * d5);
            double d7 = d6 * 57.29577951308232;
            double d8 = Math.sin(d6);
            double d9 = Math.cos(d6);
            double d10 = d8 / d9;
            double d11 = d10 * d10;
            double d12 = d11 * d11;
            double d13 = a / Math.sqrt(1.0 - Eps2 * d8 * d8);
            double d14 = a * (1.0 - Eps2) / Math.pow(1.0 - Eps2 * d8 * d8, 1.5);
            double d15 = Epps2 * d9 * d9;
            double d16 = d / (d13 * K0);
            gdc_Coord_3dArray[n].latitude = d6 - d13 * d10 / d14 * (d16 * d16 / 2.0 - (5.0 + 3.0 * d11 + 10.0 * d15 - 4.0 * d15 * d15 - 9.0 * Epps2) * d16 * d16 * d16 * d16 / 24.0 + (61.0 + 90.0 * d11 + 298.0 * d15 + 45.0 * d12 - 252.0 * Epps2 - 3.0 * d15 * d15) * d16 * d16 * d16 * d16 * d16 * d16 / 720.0);
            gdc_Coord_3dArray[n].latitude *= 57.29577951308232;
            gdc_Coord_3dArray[n].longitude = (d16 - (1.0 + 2.0 * d11 + d15) * d16 * d16 * d16 / 6.0 + (5.0 - 2.0 * d15 + 28.0 * d11 - 3.0 * d15 * d15 + 8.0 * Epps2 + 24.0 * d12) * d16 * d16 * d16 * d16 * d16 / 120.0) / d9;
            gdc_Coord_3dArray[n].longitude = (Origin_lon + gdc_Coord_3dArray[n].longitude) * 57.29577951308232;
            ++n;
        }
    }
}

