/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.Mercator_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Mercator_To_Gdc_Converter {
    static final double DEGREES_PER_RADIAN = 57.29577951308232;
    static double a;
    static double f;
    static double b;
    static double Eps2;
    static double e1;
    static double EE2;
    static double EE3;
    static double Epps2;

    public static void Init(double d, double d2) {
        Mercator_To_Gdc_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        Mercator_To_Gdc_Converter.CreateConstants(6377563.396, 299.3249646);
    }

    public static void Init(Ellipsoid ellipsoid) {
        Mercator_To_Gdc_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        a = d;
        f = 1.0 / d2;
        b = a * (1.0 - f);
        Eps2 = f * (2.0 - f);
        e1 = (1.0 - Math.sqrt(1.0 - Eps2)) / (1.0 + Math.sqrt(1.0 - Eps2));
        EE2 = Eps2 * Eps2;
        EE3 = EE2 * Eps2;
        Epps2 = Eps2 / (1.0 - Eps2);
    }

    public static void Convert(Mercator_Coord_3d mercator_Coord_3d, Gdc_Coord_3d gdc_Coord_3d) {
        Mercator_Coord_3d[] mercator_Coord_3dArray = new Mercator_Coord_3d[1];
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        mercator_Coord_3dArray[0] = mercator_Coord_3d;
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        Mercator_To_Gdc_Converter.Convert(mercator_Coord_3dArray, gdc_Coord_3dArray);
    }

    public static void Convert(Mercator_Coord_3d[] mercator_Coord_3dArray, Gdc_Coord_3d[] gdc_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            double d;
            gdc_Coord_3dArray[n].elevation = mercator_Coord_3dArray[n].z;
            double d2 = mercator_Coord_3dArray[n].x;
            double d3 = mercator_Coord_3dArray[n].y;
            double d4 = Math.pow(Math.E, -d3 / a);
            double d5 = d = 1.5707963267948966 - 2.0 * Math.atan(d4);
            do {
                d5 = d;
            } while ((d = 1.5707963267948966 - 2.0 * Math.atan(d4 * Math.pow((1.0 - Math.sqrt(Eps2) * Math.sin(d)) / (1.0 + Math.sqrt(Eps2) * Math.sin(d)), Math.sqrt(Eps2) / 2.0))) - d5 > 1.0E-10);
            gdc_Coord_3dArray[n].latitude = 1.5707963267948966 - 2.0 * Math.atan(d4 * Math.pow((1.0 - Math.sqrt(Eps2) * Math.sin(d)) / (1.0 + Math.sqrt(Eps2) * Math.sin(d)), Math.sqrt(Eps2) / 2.0));
            gdc_Coord_3dArray[n].latitude *= 57.29577951308232;
            gdc_Coord_3dArray[n].longitude = d2 / a;
            gdc_Coord_3dArray[n].longitude *= 57.29577951308232;
            ++n;
        }
    }
}

