/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.Utm_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Gdc_To_Utm_Converter {
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    static double A;
    static double F;
    static double C;
    static double Eps2;
    static double Eps25;
    static double Epps2;
    static double CScale;
    static double poly1b;
    static double poly2b;
    static double poly3b;
    static double poly4b;
    static double poly5b;

    public static void Init(double d, double d2) {
        Gdc_To_Utm_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        Gdc_To_Utm_Converter.CreateConstants(6378137.0, 298.257223563);
    }

    public static void Init(Ellipsoid ellipsoid) {
        Gdc_To_Utm_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        A = d;
        F = d2;
        F = 1.0 / F;
        C = A * (1.0 - F);
        Eps2 = F * (2.0 - F);
        Eps25 = 0.25 * Eps2;
        Epps2 = Eps2 / (1.0 - Eps2);
        double d3 = 1.0 * Eps2 + 0.25 * Math.pow(Eps2, 2.0) + 0.1171875 * Math.pow(Eps2, 3.0) - 0.111083984375 * Math.pow(Eps2, 4.0);
        d3 = 0.375 * d3;
        double d4 = 1.0 * Math.pow(Eps2, 2.0) + 0.75 * Math.pow(Eps2, 3.0) - 0.6015625 * Math.pow(Eps2, 4.0);
        d4 = 0.05859375 * d4;
        double d5 = Math.pow(Eps2, 3.0) - 1.28125 * Math.pow(Eps2, 4.0);
        d5 = d5 * 35.0 / 3072.0;
        double d6 = -0.00240325927734375 * Math.pow(Eps2, 4.0);
        poly1b = 1.0 - 0.25 * Eps2 - 0.046875 * Math.pow(Eps2, 2.0) - 0.01953125 * Math.pow(Eps2, 3.0) - 0.01068115234375 * Math.pow(Eps2, 4.0);
        poly2b = d3 * -2.0 + d4 * 4.0 - d5 * 6.0 + d6 * 8.0;
        poly3b = d4 * -8.0 + d5 * 32.0 - d6 * 80.0;
        poly4b = d5 * -32.0 + d6 * 192.0;
        poly5b = d6 * -128.0;
    }

    public static void Convert(Gdc_Coord_3d gdc_Coord_3d, Utm_Coord_3d utm_Coord_3d) {
        Gdc_To_Utm_Converter.Convert(gdc_Coord_3d, utm_Coord_3d, -1);
    }

    public static void Convert(Gdc_Coord_3d gdc_Coord_3d, Utm_Coord_3d utm_Coord_3d, int n) {
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        Utm_Coord_3d[] utm_Coord_3dArray = new Utm_Coord_3d[1];
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        utm_Coord_3dArray[0] = utm_Coord_3d;
        Gdc_To_Utm_Converter.Convert(gdc_Coord_3dArray, utm_Coord_3dArray, n);
    }

    public static void Convert(Gdc_Coord_3d[] gdc_Coord_3dArray, Utm_Coord_3d[] utm_Coord_3dArray) {
        Gdc_To_Utm_Converter.Convert(gdc_Coord_3dArray, utm_Coord_3dArray, -1);
    }

    public static void Convert(Gdc_Coord_3d[] gdc_Coord_3dArray, Utm_Coord_3d[] utm_Coord_3dArray, int n) {
        int n2 = 0;
        while (n2 < gdc_Coord_3dArray.length) {
            utm_Coord_3dArray[n2].z = gdc_Coord_3dArray[n2].elevation;
            utm_Coord_3dArray[n2].hemisphere_north = !(gdc_Coord_3dArray[n2].latitude < 0.0);
            double d = gdc_Coord_3dArray[n2].latitude * (Math.PI / 180);
            double d2 = gdc_Coord_3dArray[n2].longitude * (Math.PI / 180);
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = d3 / d4;
            double d6 = d3 * d3;
            double d7 = A / (0.25 - Eps25 * d6 + 0.249998608869975 + (0.25 - Eps25 * d6) / (0.25 - Eps25 * d6 + 0.249998608869975));
            if (n == -1) {
                utm_Coord_3dArray[n2].zone = (byte)(d2 * 30.0 / Math.PI + 31.0);
                if (utm_Coord_3dArray[n2].zone <= 0) {
                    utm_Coord_3dArray[n2].zone = 1;
                } else if (utm_Coord_3dArray[n2].zone >= 61) {
                    utm_Coord_3dArray[n2].zone = (byte)60;
                }
            } else {
                utm_Coord_3dArray[n2].zone = (byte)n;
            }
            double d8 = (double)(utm_Coord_3dArray[n2].zone * 6 - 183) * (Math.PI / 180);
            double d9 = (d2 - d8) * d4;
            double d10 = d3 * d4 * (poly2b + d6 * (poly3b + d6 * (poly4b + d6 * poly5b)));
            d10 = A * (poly1b * d + d10);
            double d11 = d5 * d5;
            double d12 = Epps2 * d4 * d4;
            double d13 = d9 * d9;
            double d14 = 1.0 - d11 + d12;
            double d15 = 5.0 + d11 * (d11 - 18.0) + d12 * (14.0 - d11 * 58.0);
            utm_Coord_3dArray[n2].x = CScale * d7 * d9 * (1.0 + d13 * (0.166666666666667 * d14 + 0.00833333333333333 * d13 * d15));
            utm_Coord_3dArray[n2].x += 500000.0;
            d14 = 5.0 - d11 + d12 * (d12 * 4.0 + 9.0);
            d15 = 61.0 + d11 * (d11 - 58.0) + d12 * (270.0 - d11 * 330.0);
            utm_Coord_3dArray[n2].y = CScale * (d10 + d7 * d5 * d13 * (0.5 + d13 * (0.0416666666666667 * d14 + 0.00138888888888888 * d13 * d15)));
            if (d < 0.0) {
                utm_Coord_3dArray[n2].y += 1.0E7;
            }
            ++n2;
        }
    }

    static {
        CScale = 0.9996;
    }
}

