/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.OSGB_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Gdc_To_OSGB_Converter {
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    static double Origin_lon_g = -2.0;
    static double Origin_lat_g = 49.0;
    static double X0 = 400000.0;
    static double Y0 = -100000.0;
    static double K0 = 0.9996012717;
    static double a;
    static double f;
    static double b;
    static double Eps2;
    static double EE2;
    static double EE3;
    static double Epps2;

    public static void Init(double d, double d2) {
        Gdc_To_OSGB_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        Gdc_To_OSGB_Converter.CreateConstants(6377563.396, 299.3249646);
    }

    public static void Init(Ellipsoid ellipsoid) {
        Gdc_To_OSGB_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        a = d;
        f = 1.0 / d2;
        b = a * (1.0 - f);
        Eps2 = f * (2.0 - f);
        EE2 = Eps2 * Eps2;
        EE3 = EE2 * Eps2;
        Epps2 = Eps2 / (1.0 - Eps2);
    }

    public static void Convert(Gdc_Coord_3d gdc_Coord_3d, OSGB_Coord_3d oSGB_Coord_3d) {
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        OSGB_Coord_3d[] oSGB_Coord_3dArray = new OSGB_Coord_3d[1];
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        oSGB_Coord_3dArray[0] = oSGB_Coord_3d;
        Gdc_To_OSGB_Converter.Convert(gdc_Coord_3dArray, oSGB_Coord_3dArray);
    }

    public static void Convert(Gdc_Coord_3d[] gdc_Coord_3dArray, OSGB_Coord_3d[] oSGB_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            oSGB_Coord_3dArray[n].z = gdc_Coord_3dArray[n].elevation;
            oSGB_Coord_3dArray[n].hemisphere_north = !(gdc_Coord_3dArray[n].latitude < 0.0);
            double d = Origin_lat_g * (Math.PI / 180);
            double d2 = Origin_lon_g * (Math.PI / 180);
            double d3 = gdc_Coord_3dArray[n].latitude * (Math.PI / 180);
            double d4 = gdc_Coord_3dArray[n].longitude * (Math.PI / 180);
            double d5 = Math.sin(d3);
            double d6 = Math.cos(d3);
            double d7 = d5 * d5;
            double d8 = d6 * d6;
            double d9 = d5 / d6;
            double d10 = d9 * d9;
            double d11 = d10 * d10;
            double d12 = d3 - d;
            double d13 = d4 - d2;
            double d14 = a * ((1.0 - Eps2 / 4.0 - 3.0 * EE2 / 64.0 - 5.0 * EE3 / 256.0) * d - (3.0 * Eps2 / 8.0 + 3.0 * EE2 / 32.0 + 45.0 * EE3 / 1024.0) * Math.sin(2.0 * d) + (15.0 * EE2 / 256.0 + 45.0 * EE3 / 1024.0) * Math.sin(4.0 * d) - 35.0 * EE3 / 3072.0 * Math.sin(6.0 * d));
            double d15 = a / Math.sqrt(1.0 - Eps2 * d7);
            double d16 = Epps2 * d8;
            double d17 = d6 * d13;
            double d18 = a * ((1.0 - Eps2 / 4.0 - 3.0 * EE2 / 64.0 - 5.0 * EE3 / 256.0) * d3 - (3.0 * Eps2 / 8.0 + 3.0 * EE2 / 32.0 + 45.0 * EE3 / 1024.0) * Math.sin(2.0 * d3) + (15.0 * EE2 / 256.0 + 45.0 * EE3 / 1024.0) * Math.sin(4.0 * d3) - 35.0 * EE3 / 3072.0 * Math.sin(6.0 * d3));
            oSGB_Coord_3dArray[n].x = X0 + K0 * d15 * (d17 + (1.0 - d10 + d16) * d17 * d17 * d17 / 6.0 + (5.0 - 18.0 * d10 + d10 * d10 + 72.0 * d16 - 58.0 * Epps2) * d17 * d17 * d17 * d17 * d17 / 120.0);
            oSGB_Coord_3dArray[n].y = Y0 + K0 * (d18 - d14 + d15 * d9 * (d17 * d17 / 2.0 + (5.0 - d10 + 9.0 * d16 + 4.0 * d16 * d16) * d17 * d17 * d17 * d17 / 24.0 + (61.0 - 58.0 * d10 + d11 + 600.0 * d16 - 330.0 * Epps2) * d17 * d17 * d17 * d17 * d17 * d17 / 720.0));
            ++n;
        }
    }
}

