/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.Mercator_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Gdc_To_Mercator_Converter {
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    static final double NUM_e = 2.302585092994046;
    static double a;
    static double f;
    static double b;
    static double Eps2;
    static double EE2;
    static double EE3;
    static double Epps2;

    public static void Init(double d, double d2) {
        Gdc_To_Mercator_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        Gdc_To_Mercator_Converter.CreateConstants(6378137.0, 298.257223563);
    }

    public static void Init(Ellipsoid ellipsoid) {
        Gdc_To_Mercator_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        a = d;
        f = 1.0 / d2;
        b = a * (1.0 - f);
        Eps2 = f * (2.0 - f);
        EE2 = Eps2 * Eps2;
        EE3 = EE2 * Eps2;
        Epps2 = Eps2 / (1.0 - Eps2);
    }

    public static void Convert(Gdc_Coord_3d gdc_Coord_3d, Mercator_Coord_3d mercator_Coord_3d) {
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        Mercator_Coord_3d[] mercator_Coord_3dArray = new Mercator_Coord_3d[1];
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        mercator_Coord_3dArray[0] = mercator_Coord_3d;
        Gdc_To_Mercator_Converter.Convert(gdc_Coord_3dArray, mercator_Coord_3dArray);
    }

    public static void Convert(Gdc_Coord_3d[] gdc_Coord_3dArray, Mercator_Coord_3d[] mercator_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            mercator_Coord_3dArray[n].z = gdc_Coord_3dArray[n].elevation;
            mercator_Coord_3dArray[n].hemisphere_north = !(gdc_Coord_3dArray[n].latitude < 0.0);
            double d = gdc_Coord_3dArray[n].latitude * (Math.PI / 180);
            double d2 = gdc_Coord_3dArray[n].longitude * (Math.PI / 180);
            double d3 = Math.sin(d);
            double d4 = Math.cos(d);
            double d5 = (1.0 + d3) / (1.0 - d3);
            mercator_Coord_3dArray[n].x = a * d2;
            double d6 = Math.pow((1.0 - Math.sqrt(Eps2) * d3) / (1.0 + Math.sqrt(Eps2) * d3), Math.sqrt(Eps2));
            mercator_Coord_3dArray[n].y = a / 2.0 * Math.log(d5 * d6);
            ++n;
        }
    }
}

