/*
 * Decompiled with CFR 0.152.
 */
package geotransform.transforms;

import geotransform.coords.Gdc_Coord_3d;
import geotransform.coords.Lambert_Coord_3d;
import geotransform.ellipsoids.Ellipsoid;

public class Gdc_To_Lambert_Converter {
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    static final double NUM_e = 2.302585092994046;
    static double Origin_lon_g = 4.356939722222222;
    static double Origin_lat_g = 90.0;
    static double X0 = 150000.01;
    static double Y0 = 5400088.44;
    static double SP1_lat_g = 49.833333333333336;
    static double SP2_lat_g = 51.166666666666664;
    static double a;
    static double f;
    static double b;
    static double Eps2;
    static double EE2;
    static double EE3;
    static double Epps2;
    static double sl1;
    static double sl2;
    static double Origin_lon;
    static double Origin_lat;
    static double SP1_lat;
    static double SP2_lat;
    static double m1;
    static double m2;
    static double t1;
    static double t2;
    static double slF;
    static double tF;
    static double n;
    static double FF;
    static double RF;

    public static void Init(double d, double d2) {
        Gdc_To_Lambert_Converter.CreateConstants(d, d2);
    }

    public static void Init() {
        Gdc_To_Lambert_Converter.CreateConstants(6378388.0, 297.0);
    }

    public static void Init(Ellipsoid ellipsoid) {
        Gdc_To_Lambert_Converter.CreateConstants(ellipsoid.a, ellipsoid.f);
    }

    protected static void CreateConstants(double d, double d2) {
        a = d;
        f = 1.0 / d2;
        b = a * (1.0 - f);
        Eps2 = f * (2.0 - f);
        EE2 = Eps2 * Eps2;
        EE3 = EE2 * Eps2;
        Epps2 = Eps2 / (1.0 - Eps2);
        Origin_lon = Origin_lon_g * (Math.PI / 180);
        Origin_lat = Origin_lat_g * (Math.PI / 180);
        SP1_lat = SP1_lat_g * (Math.PI / 180);
        SP2_lat = SP2_lat_g * (Math.PI / 180);
        sl1 = Math.sin(SP1_lat);
        m1 = Math.cos(SP1_lat) / Math.sqrt(1.0 - Eps2 * (sl1 * sl1));
        sl2 = Math.sin(SP2_lat);
        m2 = Math.cos(SP2_lat) / Math.sqrt(1.0 - Eps2 * (sl2 * sl2));
        t1 = Math.tan(0.7853981633974483 - SP1_lat / 2.0) / Math.pow((1.0 - Math.sqrt(Eps2) * sl1) / (1.0 + Math.sqrt(Eps2) * sl1), Math.sqrt(Eps2) / 2.0);
        t2 = Math.tan(0.7853981633974483 - SP2_lat / 2.0) / Math.pow((1.0 - Math.sqrt(Eps2) * sl2) / (1.0 + Math.sqrt(Eps2) * sl2), Math.sqrt(Eps2) / 2.0);
        slF = Math.sin(Origin_lat);
        tF = Math.tan(0.7853981633974483 - Origin_lat / 2.0) / Math.pow((1.0 - Math.sqrt(Eps2) * slF) / (1.0 + Math.sqrt(Eps2) * slF), Math.sqrt(Eps2) / 2.0);
        n = (Math.log(m1) - Math.log(m2)) / (Math.log(t1) - Math.log(t2));
        FF = m1 / (n * Math.pow(t1, n));
        RF = a * FF * Math.pow(tF, n);
    }

    public static void Convert(Gdc_Coord_3d gdc_Coord_3d, Lambert_Coord_3d lambert_Coord_3d) {
        Gdc_Coord_3d[] gdc_Coord_3dArray = new Gdc_Coord_3d[1];
        Lambert_Coord_3d[] lambert_Coord_3dArray = new Lambert_Coord_3d[1];
        gdc_Coord_3dArray[0] = gdc_Coord_3d;
        lambert_Coord_3dArray[0] = lambert_Coord_3d;
        Gdc_To_Lambert_Converter.Convert(gdc_Coord_3dArray, lambert_Coord_3dArray);
    }

    public static void Convert(Gdc_Coord_3d[] gdc_Coord_3dArray, Lambert_Coord_3d[] lambert_Coord_3dArray) {
        int n = 0;
        while (n < gdc_Coord_3dArray.length) {
            lambert_Coord_3dArray[n].z = gdc_Coord_3dArray[n].elevation;
            lambert_Coord_3dArray[n].hemisphere_north = !(gdc_Coord_3dArray[n].latitude < 0.0);
            double d = gdc_Coord_3dArray[n].latitude * (Math.PI / 180);
            double d2 = gdc_Coord_3dArray[n].longitude * (Math.PI / 180);
            double d3 = Math.sin(d);
            double d4 = Math.tan(0.7853981633974483 - d / 2.0) / Math.pow((1.0 - Math.sqrt(Eps2) * d3) / (1.0 + Math.sqrt(Eps2) * d3), Math.sqrt(Eps2) / 2.0);
            double d5 = a * FF * Math.pow(d4, Gdc_To_Lambert_Converter.n);
            double d6 = Gdc_To_Lambert_Converter.n * (d2 - Origin_lon);
            lambert_Coord_3dArray[n].x = X0 + d5 * Math.sin(d6);
            lambert_Coord_3dArray[n].y = Y0 + RF - d5 * Math.cos(d6);
            ++n;
        }
    }
}

