/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TextureUnitStateRetained;

public class TextureUnitState
extends NodeComponent {
    public static final int ALLOW_STATE_READ = 0;
    public static final int ALLOW_STATE_WRITE = 1;
    private static final int[] readCapabilities = new int[]{0};

    public TextureUnitState() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public TextureUnitState(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((TextureUnitStateRetained)this.retained).initTexture(texture);
        ((TextureUnitStateRetained)this.retained).initTextureAttributes(textureAttributes);
        ((TextureUnitStateRetained)this.retained).initTexCoordGeneration(texCoordGeneration);
    }

    void createRetained() {
        this.retained = new TextureUnitStateRetained();
        this.retained.setSource(this);
    }

    public void set(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState0"));
        }
        ((TextureUnitStateRetained)this.retained).setTextureUnitState(texture, textureAttributes, texCoordGeneration);
    }

    public void setTexture(Texture texture) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState0"));
        }
        ((TextureUnitStateRetained)this.retained).setTexture(texture);
    }

    public Texture getTexture() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState1"));
        }
        return ((TextureUnitStateRetained)this.retained).getTexture();
    }

    public void setTextureAttributes(TextureAttributes textureAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState2"));
        }
        ((TextureUnitStateRetained)this.retained).setTextureAttributes(textureAttributes);
    }

    public TextureAttributes getTextureAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState3"));
        }
        return ((TextureUnitStateRetained)this.retained).getTextureAttributes();
    }

    public void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState4"));
        }
        ((TextureUnitStateRetained)this.retained).setTexCoordGeneration(texCoordGeneration);
    }

    public TexCoordGeneration getTexCoordGeneration() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState5"));
        }
        return ((TextureUnitStateRetained)this.retained).getTexCoordGeneration();
    }

    public NodeComponent cloneNodeComponent() {
        TextureUnitState textureUnitState = new TextureUnitState();
        textureUnitState.duplicateNodeComponent(this);
        return textureUnitState;
    }

    public void duplicateNodeComponent(NodeComponent nodeComponent) {
        this.checkDuplicateNodeComponent(nodeComponent);
    }

    void duplicateAttributes(NodeComponent nodeComponent, boolean bl) {
        super.duplicateAttributes(nodeComponent, bl);
        Hashtable hashtable = nodeComponent.nodeHashtable;
        TextureUnitStateRetained textureUnitStateRetained = (TextureUnitStateRetained)nodeComponent.retained;
        TextureUnitStateRetained textureUnitStateRetained2 = (TextureUnitStateRetained)this.retained;
        textureUnitStateRetained2.setTexture((Texture)this.getNodeComponent(textureUnitStateRetained.getTexture(), bl, hashtable));
        textureUnitStateRetained2.setTextureAttributes((TextureAttributes)this.getNodeComponent(textureUnitStateRetained.getTextureAttributes(), bl, hashtable));
        textureUnitStateRetained2.setTexCoordGeneration((TexCoordGeneration)this.getNodeComponent(textureUnitStateRetained.getTexCoordGeneration(), bl, hashtable));
    }

    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        TextureUnitStateRetained textureUnitStateRetained = (TextureUnitStateRetained)this.retained;
        NodeComponent nodeComponent = textureUnitStateRetained.getTexture();
        if (nodeComponent != null && nodeComponent.duplicateChild()) {
            return true;
        }
        nodeComponent = textureUnitStateRetained.getTextureAttributes();
        if (nodeComponent != null && nodeComponent.getDuplicateOnCloneTree()) {
            return true;
        }
        nodeComponent = textureUnitStateRetained.getTexCoordGeneration();
        return nodeComponent != null && nodeComponent.getDuplicateOnCloneTree();
    }
}

