/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTError;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BHInternalNode;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BHNode;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CompressedGeometryRenderMethod;
import javax.media.j3d.DefaultRenderMethod;
import javax.media.j3d.DisplayListRenderMethod;
import javax.media.j3d.DrawingSurfaceObjectAWT;
import javax.media.j3d.FreeListManager;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponentUpdateInfo;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceBlockingThread;
import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dNotification;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.J3dThread;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.MasterControlThread;
import javax.media.j3d.MemoryFreeList;
import javax.media.j3d.NativeAPIInfo;
import javax.media.j3d.NotificationThread;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRenderMethod;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RenderMethod;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingAttributesStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.StructureUpdateThread;
import javax.media.j3d.Text3DRenderMethod;
import javax.media.j3d.TimerThread;
import javax.media.j3d.Transform3D;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VertexArrayRenderMethod;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class MasterControl {
    static final int CHECK_FOR_WORK = 0;
    static final int SET_WORK = 1;
    static final int RUN_THREADS = 2;
    static final int THREAD_DONE = 3;
    static final int WAIT_FOR_ALL = 4;
    static final int SET_WORK_FOR_REQUEST_RENDERER = 5;
    static final int RUN_RENDERER_CLEANUP = 6;
    static final int SLEEP = 7;
    static final int SLEEPING = 0;
    static final int RUNNING = 1;
    static final int WAITING_FOR_THREAD = 2;
    static final int WAITING_FOR_THREADS = 3;
    static final int WAITING_FOR_CPU = 4;
    static final int WAITING_FOR_RENDERER_CLEANUP = 5;
    static final int RENDER_OPENGL_SOLARIS = 0;
    static final int RENDER_OPENGL_WIN32 = 1;
    static final int RENDER_DIRECT3D = 2;
    static final int RENDER_OPENGL_LINUX = 3;
    static final Integer REQUESTRENDER;
    static final Integer RENDER;
    static final Integer SWAP;
    static final Integer ACTIVATE_VIEW;
    static final Integer DEACTIVATE_VIEW;
    static final Integer START_VIEW;
    static final Integer STOP_VIEW;
    static final Integer REEVALUATE_CANVAS;
    static final Integer UNREGISTER_VIEW;
    static final Integer PHYSICAL_ENV_CHANGE;
    static final Integer INPUTDEVICE_CHANGE;
    static final Integer EMPTY_UNIVERSE;
    static final Integer START_RENDERER;
    static final Integer STOP_RENDERER;
    static final Integer RENDER_ONCE;
    static final Integer FREE_CONTEXT;
    static final Integer FREE_DRAWING_SURFACE;
    static final Integer FREE_MESSAGE;
    static final Integer RESET_CANVAS;
    static final Integer GETBESTCONFIG;
    static final Integer ISCONFIGSUPPORT;
    static final Integer SET_GRAPHICSCONFIG_FEATURES;
    static final Integer SET_QUERYPROPERTIES;
    static final Integer SET_VIEW;
    private static boolean librariesLoaded;
    private MasterControlThread mcThread = null;
    private UnorderList views = new UnorderList(1, View.class);
    boolean transparentOffScreen = false;
    boolean usePbuffer = true;
    boolean viewFrustumCulling = true;
    private boolean lockGeometry = false;
    private int numActiveViews = 0;
    private ImageComponentUpdateInfo[] imageUpdateInfoList = new ImageComponentUpdateInfo[2];
    private int numFreeImageUpdateInfo = 0;
    private UnorderList activeUniverseList = new UnorderList(VirtualUniverse.class);
    private UnorderList regUniverseList = new UnorderList(VirtualUniverse.class);
    private Object timeLock = new Object();
    private long time = 0L;
    private long waitTimestamp = 0L;
    private UnorderList stateWorkThreads = new UnorderList(J3dThreadData.class);
    private UnorderList renderWorkThreads = new UnorderList(J3dThreadData.class);
    private UnorderList requestRenderWorkThreads = new UnorderList(J3dThreadData.class);
    private UnorderList renderThreadData = new UnorderList(J3dThreadData.class);
    private UnorderList inputDeviceThreads = new UnorderList(1, InputDeviceScheduler.class);
    private boolean threadListsChanged;
    private int lastTransformStructureThread = 0;
    private int lastStructureUpdateThread = 0;
    private long currentTime;
    TimerThread timerThread;
    private NotificationThread notificationThread;
    volatile boolean running = true;
    private boolean workToDo = false;
    private boolean requestRenderWorkToDo = false;
    private int threadPending = 0;
    private int renderPending = 0;
    private int statePending = 0;
    private boolean renderWaiting = false;
    private boolean stateWaiting = false;
    private int state = 0;
    private long sleepTime = 0L;
    private int cpuLimit;
    private UnorderList mirrorObjects = new UnorderList(ObjectUpdate.class);
    private RenderingAttributesStructure renderingAttributesStructure = new RenderingAttributesStructure();
    private DefaultRenderMethod defaultRenderMethod = null;
    private Text3DRenderMethod text3DRenderMethod = null;
    private VertexArrayRenderMethod vertexArrayRenderMethod = null;
    private DisplayListRenderMethod displayListRenderMethod = null;
    private CompressedGeometryRenderMethod compressedGeometryRenderMethod = null;
    private OrientedShape3DRenderMethod orientedShape3DRenderMethod = null;
    static long systemStartTime;
    private int renderingAPI = 0;
    static boolean isD3DAPI;
    static boolean isWin32;
    private NativeAPIInfo nativeAPIInfo = null;
    private int textureIdCount = 0;
    private Object textureIdLock = new Object();
    private long contextTimeStamp = 0L;
    private boolean[] canvasIds = null;
    private int canvasFreeIndex = 0;
    private Object canvasIdLock = new Object();
    private int rendererCount = 0;
    boolean isSharedCtx = false;
    boolean useCombiners = false;
    boolean disableCompile = false;
    boolean doCompaction = true;
    boolean disableSeparateSpecularColor = false;
    boolean isDisplayList = true;
    boolean buildDisplayListIfPossible = false;
    boolean vertexAttrsInDisplayList = false;
    boolean allowSoleUser = false;
    static int globalShadingLanguage;
    static boolean cgLibraryAvailable;
    static boolean glslLibraryAvailable;
    static Integer REMOVEALLCTXS_CLEANUP;
    static Integer REMOVECTX_CLEANUP;
    static Integer REMOVENOTIFY_CLEANUP;
    static Integer RESETCANVAS_CLEANUP;
    static Integer FREECONTEXT_CLEANUP;
    Object[] rendererCleanupArgs = new Object[]{new Integer(3), null, null};
    Object contextCreationLock = new Object();
    boolean doDsiRenderLock = false;
    boolean isJ3dG2dDrawPixel = false;
    boolean isBackgroundTexture = true;
    boolean sharedStereoZBuffer;
    boolean implicitAntialiasing = false;
    boolean isCompiledVertexArray = true;
    boolean isForceNormalized = false;
    boolean allowSimulatedMultiTexture = false;
    Hashtable deviceScreenMap = new Hashtable();
    UnorderList requestObjList = new UnorderList();
    private UnorderList requestTypeList = new UnorderList(Integer.class);
    private UnorderList tempViewList = new UnorderList();
    private UnorderList renderOnceList = new UnorderList();
    private boolean pendingRequest = false;
    private static ThreadGroup rootThreadGroup;
    private static int threadPriority;
    private static Object mcThreadLock;
    private ArrayList timestampUpdateList = new ArrayList(3);
    private UnorderList freeMessageList = new UnorderList(8);
    private static final String[] systemPathProps;
    long awt;
    int maxLights;
    int resendTexTimestamp = 0;
    boolean xineramaDisabled = false;
    boolean sortShape3DBounds = false;
    boolean forceReleaseView = false;
    static String[] mtype;
    int frameCount = 0;
    private int frameCountCutoff = 100;
    static final /* synthetic */ boolean $assertionsDisabled;

    private native long getAWT();

    private native boolean initializeJ3D(boolean var1);

    private static native boolean loadNativeCgLibrary(String[] var0);

    private native int getNumberOfProcessor();

    private native void setThreadConcurrency(int var1);

    private native int getThreadConcurrency();

    static native long getNativeTimerValue();

    private native int getMaximumLights();

    MasterControl() {
        Integer n;
        if (!$assertionsDisabled && !librariesLoaded) {
            throw new AssertionError();
        }
        this.awt = this.getAWT();
        this.nativeAPIInfo = new NativeAPIInfo();
        this.renderingAPI = this.nativeAPIInfo.getRenderingAPI();
        isD3DAPI = this.renderingAPI == 2;
        boolean bl = isWin32 = isD3DAPI || this.renderingAPI == 1;
        if (systemStartTime == 0L) {
            systemStartTime = J3dClock.currentTimeMillis();
        }
        if (this.getRenderingAPI() != 2) {
            this.isSharedCtx = MasterControl.getBooleanProperty("j3d.sharedctx", this.isSharedCtx, "shared contexts");
        }
        this.doCompaction = MasterControl.getBooleanProperty("j3d.docompaction", this.doCompaction, "compaction");
        this.transparentOffScreen = MasterControl.getBooleanProperty("j3d.transparentOffScreen", this.transparentOffScreen, "transparent OffScreen");
        this.usePbuffer = MasterControl.getBooleanProperty("j3d.usePbuffer", this.usePbuffer, "Off-screen Pbuffer");
        this.viewFrustumCulling = MasterControl.getBooleanProperty("j3d.viewFrustumCulling", this.viewFrustumCulling, "View frustum culling in the renderer is");
        this.sortShape3DBounds = MasterControl.getBooleanProperty("j3d.sortShape3DBounds", this.sortShape3DBounds, "Shape3D bounds enabled for transparency sorting", "Shape3D bounds *ignored* for transparency sorting");
        this.forceReleaseView = MasterControl.getBooleanProperty("j3d.forceReleaseView", this.forceReleaseView, "forceReleaseView  after Canvas3D dispose enabled", "forceReleaseView  after Canvas3D dispose disabled");
        this.useCombiners = MasterControl.getBooleanProperty("j3d.usecombiners", this.useCombiners, "Using NV_register_combiners if available", "NV_register_combiners disabled");
        if (MasterControl.getProperty("j3d.disablecompile") != null) {
            this.disableCompile = true;
            System.err.println("Java 3D: BranchGroup.compile disabled");
        }
        if (MasterControl.getProperty("j3d.disableSeparateSpecular") != null) {
            this.disableSeparateSpecularColor = true;
            System.err.println("Java 3D: separate specular color disabled if possible");
        }
        this.isDisplayList = MasterControl.getBooleanProperty("j3d.displaylist", this.isDisplayList, "display list");
        this.implicitAntialiasing = MasterControl.getBooleanProperty("j3d.implicitAntialiasing", this.implicitAntialiasing, "implicit antialiasing");
        this.isCompiledVertexArray = MasterControl.getBooleanProperty("j3d.compiledVertexArray", this.isCompiledVertexArray, "compiled vertex array");
        this.isForceNormalized = MasterControl.getBooleanProperty("j3d.forceNormalized", this.isForceNormalized, "force normalized");
        this.allowSimulatedMultiTexture = MasterControl.getBooleanProperty("j3d.simulatedMultiTexture", this.allowSimulatedMultiTexture, "simulated multi-texture");
        if (this.allowSimulatedMultiTexture) {
            System.err.println("************************************************************************");
            System.err.println(J3dI18N.getString("MasterControl2"));
            System.err.println(J3dI18N.getString("MasterControl3"));
            System.err.println("************************************************************************");
        }
        boolean bl2 = MasterControl.getBooleanProperty("j3d.optimizeForSpace", true, "optimize for space");
        if (this.isDisplayList) {
            if (!bl2) {
                this.buildDisplayListIfPossible = true;
            }
            if (glslLibraryAvailable) {
                this.vertexAttrsInDisplayList = true;
            }
        }
        this.doDsiRenderLock = MasterControl.getBooleanProperty("j3d.renderLock", this.doDsiRenderLock, "render lock");
        this.isJ3dG2dDrawPixel = MasterControl.getBooleanProperty("j3d.g2ddrawpixel", this.isJ3dG2dDrawPixel, "Graphics2D DrawPixel");
        this.allowSoleUser = MasterControl.getBooleanProperty("j3d.allowSoleUser", this.allowSoleUser, "sole-user mode");
        this.isBackgroundTexture = !this.isD3D() ? MasterControl.getBooleanProperty("j3d.backgroundtexture", this.isBackgroundTexture, "background texture") : false;
        boolean bl3 = this.getRenderingAPI() != 0;
        this.sharedStereoZBuffer = MasterControl.getBooleanProperty("j3d.sharedstereozbuffer", bl3, "shared stereo Z buffer");
        final int n2 = this.getNumberOfProcessor() + 1;
        Integer n3 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.threadLimit", n2);
            }
        });
        this.cpuLimit = n3;
        if (this.cpuLimit < 1) {
            this.cpuLimit = 1;
        }
        if (J3dDebug.debug || this.cpuLimit != n2) {
            System.err.println("Java 3D: concurrent threadLimit = " + this.cpuLimit);
        }
        int n4 = this.getThreadConcurrency();
        if (J3dDebug.debug) {
            System.err.println("System threadConcurrency = " + n4);
        }
        if (n4 != -1 && n4 < this.cpuLimit + 1) {
            n4 = this.cpuLimit + 1;
            if (J3dDebug.debug) {
                System.err.println("Setting system threadConcurrency to " + n4);
            }
            this.setThreadConcurrency(n4);
        }
        if ((n = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Integer.getInteger("j3d.deviceSampleTime", 0);
            }
        })) > 0) {
            InputDeviceScheduler.samplingTime = n;
            System.err.println("Java 3D: Input device sampling time = " + n + " ms");
        }
        boolean bl4 = false;
        if (MasterControl.getProperty("j3d.disableXinerama") != null) {
            bl4 = true;
        }
        if (!this.initializeJ3D(bl4)) {
            if (this.isGreenThreadUsed()) {
                System.err.print(J3dI18N.getString("MasterControl1"));
            }
            throw new RuntimeException(J3dI18N.getString("MasterControl0"));
        }
        if (this.xineramaDisabled) {
            System.err.println("Java 3D: Xinerama disabled");
        } else if (bl4) {
            System.err.println("Java 3D: could not disable Xinerama");
        }
        this.maxLights = this.getMaximumLights();
        FreeListManager.createFreeLists();
        this.canvasIds = new boolean[32];
        for (int i = 0; i < this.canvasIds.length; ++i) {
            this.canvasIds[i] = false;
        }
        this.canvasFreeIndex = 0;
    }

    private static String getProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    private static boolean getBooleanProperty(String string, boolean bl, String string2, String string3) {
        boolean bl2 = bl;
        String string4 = MasterControl.getProperty(string);
        if (string4 != null) {
            bl2 = Boolean.valueOf(string4);
            System.err.println("Java 3D: " + (bl2 ? string2 : string3));
        }
        return bl2;
    }

    private static boolean getBooleanProperty(String string, boolean bl, String string2) {
        return MasterControl.getBooleanProperty(string, bl, string2 + " enabled", string2 + " disabled");
    }

    boolean isGreenThreadUsed() {
        return false;
    }

    static void loadLibraries() {
        String string;
        String[] stringArray;
        if (!$assertionsDisabled && librariesLoaded) {
            throw new AssertionError();
        }
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit = null;
        }
        catch (AWTError aWTError) {
            // empty catch block
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("jawt");
                return null;
            }
        });
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                String string2 = "j3dcore-ogl";
                String string3 = System.getProperty("os.name");
                if (string3 != null && string3.startsWith("Windows") && (string = System.getProperty("j3d.rend")) != null && string.equals("d3d")) {
                    string2 = "j3dcore-d3d";
                }
                System.loadLibrary(string2);
                return string2;
            }
        });
        String string3 = MasterControl.getProperty("j3d.shadingLanguage");
        if (string3 != null) {
            boolean bl = false;
            if (string3.equals("GLSL")) {
                globalShadingLanguage = 1;
                bl = true;
            } else if (string3.equals("Cg")) {
                globalShadingLanguage = 2;
                bl = true;
            }
            if (bl) {
                System.err.println("Java 3D: Setting global shading language to " + string3);
            } else {
                System.err.println("Java 3D: Unrecognized shading language: " + string3);
            }
        }
        if (globalShadingLanguage == 2 && MasterControl.loadNativeCgLibrary(stringArray = MasterControl.setupLibPath(systemPathProps, string = string2 + "-cg"))) {
            cgLibraryAvailable = true;
        }
        if (globalShadingLanguage == 1 && string2 == "j3dcore-ogl") {
            glslLibraryAvailable = true;
        }
        if (!$assertionsDisabled && glslLibraryAvailable && cgLibraryAvailable) {
            throw new AssertionError((Object)"ERROR: cannot support both GLSL and CG at the same time");
        }
        librariesLoaded = true;
    }

    private static String[] setupLibPath(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = System.mapLibraryName(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = MasterControl.getProperty(stringArray[i]);
            boolean bl = false;
            int n = 0;
            while (!bl) {
                String string4;
                File file;
                int n2 = string3.indexOf(File.pathSeparator, n);
                if (n2 == -1) {
                    n2 = string3.length();
                    bl = true;
                }
                if ((file = new File(string4 = string3.substring(n, n2), string2)).exists()) {
                    arrayList.add(file.getAbsolutePath());
                }
                n = n2 + 1;
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    InputDeviceBlockingThread getInputDeviceBlockingThread(final InputDevice inputDevice) {
        return (InputDeviceBlockingThread)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    InputDeviceBlockingThread inputDeviceBlockingThread = new InputDeviceBlockingThread(rootThreadGroup, inputDevice);
                    inputDeviceBlockingThread.setPriority(threadPriority);
                    return inputDeviceBlockingThread;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setThreadPriority(final int n) {
        ThreadGroup threadGroup = rootThreadGroup;
        synchronized (threadGroup) {
            threadPriority = n;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread[] threadArray = new Thread[rootThreadGroup.activeCount()];
                    int n2 = rootThreadGroup.enumerate(threadArray);
                    for (int i = n2 - 1; i >= 0; --i) {
                        threadArray[i].setPriority(n);
                    }
                    return null;
                }
            });
        }
    }

    int getThreadPriority() {
        return threadPriority;
    }

    int getRendererBit() {
        return 1 << this.rendererCount++;
    }

    int getRendererId() {
        return this.rendererCount++;
    }

    long getContextTimeStamp() {
        return ++this.contextTimeStamp;
    }

    Integer getDisplayListId() {
        return (Integer)FreeListManager.getObject(4);
    }

    void freeDisplayListId(Integer n) {
        FreeListManager.freeObject(4, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTexture2DId() {
        MemoryFreeList memoryFreeList = FreeListManager.getFreeList(5);
        Object object = this.textureIdLock;
        synchronized (object) {
            if (memoryFreeList.size() > 0) {
                return (Integer)FreeListManager.getObject(5);
            }
            return ++this.textureIdCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTexture3DId() {
        MemoryFreeList memoryFreeList = FreeListManager.getFreeList(6);
        Object object = this.textureIdLock;
        synchronized (object) {
            if (memoryFreeList.size > 0) {
                return (Integer)FreeListManager.getObject(6);
            }
            return ++this.textureIdCount;
        }
    }

    void freeTexture2DId(int n) {
        FreeListManager.freeObject(5, new Integer(n));
    }

    void freeTexture3DId(int n) {
        FreeListManager.freeObject(6, new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCanvasId() {
        int n;
        Object object = this.canvasIdLock;
        synchronized (object) {
            for (n = this.canvasFreeIndex; n < this.canvasIds.length && this.canvasIds[n]; ++n) {
            }
            if (this.canvasFreeIndex >= this.canvasIds.length) {
                throw new RuntimeException("Cannot render to more than 32 Canvas3Ds");
            }
            this.canvasIds[n] = true;
            this.canvasFreeIndex = n + 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeCanvasId(int n) {
        Object object = this.canvasIdLock;
        synchronized (object) {
            this.canvasIds[n] = false;
            if (this.canvasFreeIndex > n) {
                this.canvasFreeIndex = n;
            }
        }
    }

    Transform3D getTransform3D(Transform3D transform3D) {
        Transform3D transform3D2 = (Transform3D)FreeListManager.getObject(2);
        if (transform3D != null) {
            transform3D2.set(transform3D);
        }
        return transform3D2;
    }

    void addToTransformFreeList(Transform3D transform3D) {
        FreeListManager.freeObject(2, transform3D);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImageComponentUpdateInfo getFreeImageUpdateInfo() {
        ImageComponentUpdateInfo[] imageComponentUpdateInfoArray = this.imageUpdateInfoList;
        synchronized (this.imageUpdateInfoList) {
            ImageComponentUpdateInfo imageComponentUpdateInfo;
            if (this.numFreeImageUpdateInfo > 0) {
                --this.numFreeImageUpdateInfo;
                imageComponentUpdateInfo = this.imageUpdateInfoList[this.numFreeImageUpdateInfo];
            } else {
                imageComponentUpdateInfo = new ImageComponentUpdateInfo();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return imageComponentUpdateInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFreeImageUpdateInfo(ImageComponentUpdateInfo imageComponentUpdateInfo) {
        ImageComponentUpdateInfo[] imageComponentUpdateInfoArray = this.imageUpdateInfoList;
        synchronized (this.imageUpdateInfoList) {
            if (this.imageUpdateInfoList.length == this.numFreeImageUpdateInfo) {
                ImageComponentUpdateInfo[] imageComponentUpdateInfoArray2 = new ImageComponentUpdateInfo[this.numFreeImageUpdateInfo * 2];
                System.arraycopy(this.imageUpdateInfoList, 0, imageComponentUpdateInfoArray2, 0, this.numFreeImageUpdateInfo);
                imageComponentUpdateInfoArray2[this.numFreeImageUpdateInfo++] = imageComponentUpdateInfo;
                this.imageUpdateInfoList = imageComponentUpdateInfoArray2;
            } else {
                this.imageUpdateInfoList[this.numFreeImageUpdateInfo++] = imageComponentUpdateInfo;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFreeImageUpdateInfo(ArrayList arrayList) {
        ImageComponentUpdateInfo[] imageComponentUpdateInfoArray = this.imageUpdateInfoList;
        synchronized (this.imageUpdateInfoList) {
            int n = this.numFreeImageUpdateInfo + arrayList.size();
            if (this.imageUpdateInfoList.length <= n) {
                ImageComponentUpdateInfo[] imageComponentUpdateInfoArray2 = new ImageComponentUpdateInfo[n * 2];
                System.arraycopy(this.imageUpdateInfoList, 0, imageComponentUpdateInfoArray2, 0, this.numFreeImageUpdateInfo);
                this.imageUpdateInfoList = imageComponentUpdateInfoArray2;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ImageComponentUpdateInfo imageComponentUpdateInfo = (ImageComponentUpdateInfo)arrayList.get(i);
                if (imageComponentUpdateInfo == null) continue;
                this.imageUpdateInfoList[this.numFreeImageUpdateInfo++] = imageComponentUpdateInfo;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private Renderer createRenderer(GraphicsConfiguration graphicsConfiguration) {
        final GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        Renderer renderer = (Renderer)Screen3D.deviceRendererMap.get(graphicsDevice);
        if (renderer != null) {
            return renderer;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    Renderer renderer = new Renderer(rootThreadGroup);
                    renderer.initialize();
                    renderer.setPriority(threadPriority);
                    Screen3D.deviceRendererMap.put(graphicsDevice, renderer);
                }
                return null;
            }
        });
        this.threadListsChanged = true;
        return (Renderer)Screen3D.deviceRendererMap.get(graphicsDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRequest(Integer n, Object object) {
        Object object2 = mcThreadLock;
        synchronized (object2) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.mcThread == null) {
                    if (n == ACTIVATE_VIEW || n == GETBESTCONFIG || n == SET_VIEW || n == ISCONFIGSUPPORT || n == SET_QUERYPROPERTIES || n == SET_GRAPHICSCONFIG_FEATURES) {
                        this.createMasterControlThread();
                        this.requestObjList.add(object);
                        this.requestTypeList.add(n);
                        this.pendingRequest = true;
                    } else if (n == EMPTY_UNIVERSE) {
                        this.destroyUniverseThreads((VirtualUniverse)object);
                    } else if (n == STOP_VIEW) {
                        View view = (View)object;
                        view.stopViewCount = -1;
                        view.isRunning = false;
                    } else if (n == STOP_RENDERER) {
                        if (object instanceof Canvas3D) {
                            ((Canvas3D)object).isRunningStatus = false;
                        } else {
                            ((Renderer)object).userStop = true;
                        }
                    } else if (n == UNREGISTER_VIEW) {
                        ((View)object).doneUnregister = true;
                    } else {
                        this.requestObjList.add(object);
                        this.requestTypeList.add(n);
                        this.pendingRequest = true;
                    }
                } else {
                    this.requestObjList.add(object);
                    this.requestTypeList.add(n);
                    this.pendingRequest = true;
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mcThreadDone() {
        Object object = mcThreadLock;
        synchronized (object) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (!this.pendingRequest) {
                    this.mcThread = null;
                    if (this.renderingAttributesStructure.updateThread != null) {
                        this.renderingAttributesStructure.updateThread.finish();
                        this.renderingAttributesStructure.updateThread = null;
                    }
                    this.renderingAttributesStructure = new RenderingAttributesStructure();
                    if (this.timerThread != null) {
                        this.timerThread.finish();
                        this.timerThread = null;
                    }
                    if (this.notificationThread != null) {
                        this.notificationThread.finish();
                        this.notificationThread = null;
                    }
                    this.requestObjList.clear();
                    this.requestTypeList.clear();
                    return true;
                }
                this.running = true;
                this.createMCThreads();
                return false;
            }
        }
    }

    final int getRenderingAPI() {
        return this.renderingAPI;
    }

    final boolean isD3D() {
        return isD3DAPI;
    }

    final long getTime() {
        return this.time++;
    }

    void addBHNodeToFreelists(BHNode bHNode) {
        bHNode.parent = null;
        bHNode.mark = false;
        if (bHNode.nodeType == 1) {
            ((BHInternalNode)bHNode).lChild = null;
            ((BHInternalNode)bHNode).rChild = null;
            FreeListManager.freeObject(3, bHNode);
        } else if (bHNode.nodeType == 2) {
            ((BHLeafNode)bHNode).leafIF = null;
            FreeListManager.freeObject(1, bHNode);
        }
    }

    BHNode getBHNode(int n) {
        if (n == 2) {
            return (BHNode)FreeListManager.getObject(1);
        }
        if (n == 1) {
            return (BHNode)FreeListManager.getObject(3);
        }
        return null;
    }

    final void addMessageToFreelists(J3dMessage j3dMessage) {
        FreeListManager.freeObject(0, j3dMessage);
    }

    final J3dMessage getMessage() {
        return (J3dMessage)FreeListManager.getObject(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(J3dMessage j3dMessage) {
        Object object = this.timeLock;
        synchronized (object) {
            j3dMessage.time = this.getTime();
            this.sendMessage(j3dMessage);
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMessage(J3dMessage[] j3dMessageArray) {
        Object object = this.timeLock;
        synchronized (object) {
            long l = this.getTime();
            for (int i = 0; i < j3dMessageArray.length; ++i) {
                j3dMessageArray[i].time = l;
                this.sendMessage(j3dMessageArray[i]);
            }
        }
        this.setWork();
    }

    void sendNotification(J3dNotification j3dNotification) {
        this.notificationThread.addNotification(j3dNotification);
    }

    void createMasterControlThread() {
        this.running = true;
        this.workToDo = true;
        this.state = 1;
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.mcThread = new MasterControlThread(rootThreadGroup);
                    MasterControl.this.mcThread.setPriority(threadPriority);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(J3dMessage j3dMessage) {
        J3dMessage j3dMessage2 = j3dMessage;
        synchronized (j3dMessage2) {
            int n;
            View[] viewArray;
            UnorderList unorderList;
            VirtualUniverse virtualUniverse = j3dMessage.universe;
            int n2 = j3dMessage.threads;
            if ((n2 & 0x400) != 0) {
                this.renderingAttributesStructure.addMessage(j3dMessage);
            }
            if (virtualUniverse != null) {
                if ((n2 & 0x40) != 0) {
                    virtualUniverse.geometryStructure.addMessage(j3dMessage);
                }
                if ((n2 & 0x2000) != 0) {
                    virtualUniverse.transformStructure.addMessage(j3dMessage);
                }
                if ((n2 & 0x100) != 0) {
                    virtualUniverse.behaviorStructure.addMessage(j3dMessage);
                }
                if ((n2 & 0x200) != 0) {
                    virtualUniverse.soundStructure.addMessage(j3dMessage);
                }
                if ((n2 & 0x1000) != 0) {
                    virtualUniverse.renderingEnvironmentStructure.addMessage(j3dMessage);
                }
            }
            if ((n2 & 2) != 0) {
                if (j3dMessage.view != null && j3dMessage.view.soundScheduler != null) {
                    j3dMessage.view.soundScheduler.addMessage(j3dMessage);
                } else {
                    unorderList = this.views;
                    synchronized (unorderList) {
                        viewArray = (View[])this.views.toArray(false);
                        if (virtualUniverse == null) {
                            while (n >= 0) {
                                viewArray[n--].soundScheduler.addMessage(j3dMessage);
                            }
                        } else {
                            for (n = this.views.arraySize() - 1; n >= 0; --n) {
                                if (viewArray[n].universe != virtualUniverse) continue;
                                viewArray[n].soundScheduler.addMessage(j3dMessage);
                            }
                        }
                    }
                }
            }
            if ((n2 & 0x80) != 0) {
                if (j3dMessage.view != null && j3dMessage.view.renderBin != null) {
                    j3dMessage.view.renderBin.addMessage(j3dMessage);
                } else {
                    unorderList = this.views;
                    synchronized (unorderList) {
                        viewArray = (View[])this.views.toArray(false);
                        n = this.views.arraySize() - 1;
                        if (virtualUniverse == null) {
                            while (n >= 0) {
                                viewArray[n--].renderBin.addMessage(j3dMessage);
                            }
                        } else {
                            while (n >= 0) {
                                if (viewArray[n].universe == virtualUniverse) {
                                    viewArray[n].renderBin.addMessage(j3dMessage);
                                }
                                --n;
                            }
                        }
                    }
                }
            }
            if (j3dMessage.getRefcount() == 0) {
                j3dMessage.clear();
                this.addMessageToFreelists(j3dMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(int n) {
        Object object = this.timeLock;
        synchronized (object) {
            int n2;
            Object[] objectArray;
            UnorderList unorderList;
            long l = this.getTime();
            if ((n & 4) != 0) {
                unorderList = this.inputDeviceThreads;
                synchronized (unorderList) {
                    objectArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(false);
                    for (n2 = this.inputDeviceThreads.size() - 1; n2 >= 0; --n2) {
                        if (((InputDeviceScheduler)objectArray[n2]).physicalEnv.activeViewRef <= 0) continue;
                        ((InputDeviceScheduler)objectArray[n2]).getThreadData().lastUpdateTime = l;
                    }
                    if (this.timerThread != null) {
                        this.timerThread.addInputDeviceSchedCond();
                    }
                }
            }
            if ((n & 0x10) != 0) {
                unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    objectArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                    n2 = this.renderThreadData.arraySize() - 1;
                    while (n2 >= 0) {
                        Object object2 = objectArray[n2--];
                        if (!((J3dThreadData)object2).view.renderBinReady) continue;
                        ((J3dThreadData)object2).lastUpdateTime = l;
                    }
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(long l, View view, int n) {
        Object object = this.timeLock;
        synchronized (object) {
            long l2 = this.getTime();
            if ((n & 2) != 0) {
                if (view.soundScheduler != null) {
                    view.soundScheduler.threadData.lastUpdateTime = l2;
                }
                this.timerThread.addSoundSchedCond(l2 + l);
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(View view, int n) {
        Object object = this.timeLock;
        synchronized (object) {
            long l = this.getTime();
            if ((n & 0x10) != 0) {
                UnorderList unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                    int n2 = this.renderThreadData.arraySize() - 1;
                    while (n2 >= 0) {
                        J3dThreadData j3dThreadData = j3dThreadDataArray[n2--];
                        if (j3dThreadData.view != view || !view.renderBinReady) continue;
                        j3dThreadData.lastUpdateTime = l;
                    }
                }
            }
        }
        this.setWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRunMessage(VirtualUniverse virtualUniverse, int n) {
        Object object = this.timeLock;
        synchronized (object) {
            int n2;
            Object[] objectArray;
            UnorderList unorderList;
            long l = this.getTime();
            if ((n & 1) != 0 && virtualUniverse.behaviorScheduler != null) {
                virtualUniverse.behaviorScheduler.getThreadData(null, null).lastUpdateTime = l;
            }
            if ((n & 0x100) != 0) {
                virtualUniverse.behaviorStructure.threadData.lastUpdateTime = l;
            }
            if ((n & 0x40) != 0) {
                virtualUniverse.geometryStructure.threadData.lastUpdateTime = l;
            }
            if ((n & 0x200) != 0) {
                virtualUniverse.soundStructure.threadData.lastUpdateTime = l;
            }
            if ((n & 2) != 0) {
                unorderList = this.views;
                synchronized (unorderList) {
                    objectArray = (View[])this.views.toArray(false);
                    for (n2 = this.views.arraySize() - 1; n2 >= 0; --n2) {
                        if (((View)objectArray[n2]).soundScheduler == null || ((View)objectArray[n2]).universe != virtualUniverse) continue;
                        ((View)objectArray[n2]).soundScheduler.threadData.lastUpdateTime = l;
                    }
                }
            }
            if ((n & 0x10) != 0) {
                unorderList = this.renderThreadData;
                synchronized (unorderList) {
                    objectArray = (J3dThreadData[])this.renderThreadData.toArray(false);
                    n2 = this.renderThreadData.arraySize() - 1;
                    while (n2 >= 0) {
                        Object object2 = objectArray[n2--];
                        if (((J3dThreadData)object2).view.universe != virtualUniverse || !((J3dThreadData)object2).view.renderBinReady) continue;
                        ((J3dThreadData)object2).lastUpdateTime = l;
                    }
                }
            }
        }
        this.setWork();
    }

    UnorderList cloneView() {
        return (UnorderList)this.views.clone();
    }

    boolean isRegistered(View view) {
        return this.views.contains(view);
    }

    private void updateTimeValues() {
        int n = 0;
        J3dThreadData j3dThreadData = null;
        J3dThreadData j3dThreadData2 = null;
        long l = this.currentTime;
        this.currentTime = this.getTime();
        J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
        int n2 = this.stateWorkThreads.arraySize();
        while (n < this.lastTransformStructureThread) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        while (n < this.lastStructureUpdateThread) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        while (n < n2) {
            j3dThreadData2 = j3dThreadDataArray[n++];
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                j3dThreadData = j3dThreadData2;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.threadOpts = 2;
                j3dThreadData2.lastRunTime = this.currentTime;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts = 1;
            j3dThreadData = null;
        }
        j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
        n2 = this.renderWorkThreads.arraySize();
        J3dThreadData j3dThreadData3 = null;
        ++this.waitTimestamp;
        this.sleepTime = 0L;
        boolean bl = false;
        View view = null;
        for (n = 0; n < n2; ++n) {
            j3dThreadData2 = j3dThreadDataArray[n];
            if (j3dThreadData2.view != view) {
                j3dThreadData2.view.computeCycleTime();
                if (j3dThreadData2.view.sleepTime > this.sleepTime) {
                    this.sleepTime = j3dThreadData2.view.sleepTime;
                }
            }
            view = j3dThreadData2.view;
        }
        view = null;
        for (n = 0; n < n2; ++n) {
            j3dThreadData2 = j3dThreadDataArray[n];
            if (j3dThreadData2.canvas == null) {
                ((Object[])j3dThreadData2.threadArgs)[3] = null;
            }
            if (j3dThreadData2.lastUpdateTime > j3dThreadData2.lastRunTime && !j3dThreadData2.thread.userStop) {
                if (j3dThreadData2.thread.lastWaitTimestamp == this.waitTimestamp) {
                    ++this.waitTimestamp;
                    if (j3dThreadData2.view != view) {
                        view = j3dThreadData2.view;
                        bl = true;
                        j3dThreadData3.threadOpts = 17;
                        ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                        j3dThreadData2.threadOpts = 10;
                    } else {
                        j3dThreadData3.threadOpts = (j3dThreadData3.threadOpts & 8) != 0 ? 9 : 1;
                        j3dThreadData2.threadOpts = 2;
                    }
                } else if (j3dThreadData2.view != view) {
                    view = j3dThreadData2.view;
                    bl = true;
                    if (j3dThreadData3 != null) {
                        j3dThreadData3.threadOpts = 17;
                        ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
                    }
                    j3dThreadData2.threadOpts = 10;
                } else {
                    j3dThreadData2.threadOpts = 2;
                }
                j3dThreadData2.thread.lastWaitTimestamp = this.waitTimestamp;
                j3dThreadData2.needsRun = true;
                j3dThreadData2.lastRunTime = this.currentTime;
                j3dThreadData3 = j3dThreadData2;
                continue;
            }
            j3dThreadData2.needsRun = false;
        }
        if (j3dThreadData3 != null) {
            j3dThreadData3.threadOpts = 49;
            this.lockGeometry = true;
            ((Object[])j3dThreadData3.threadArgs)[3] = j3dThreadData3.view;
        } else {
            this.lockGeometry = false;
        }
        if (this.sleepTime > 0L) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                System.err.println(interruptedException);
            }
        }
    }

    private void createUpdateThread(J3dStructure j3dStructure) {
        final J3dStructure j3dStructure2 = j3dStructure;
        if (j3dStructure2.updateThread == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        j3dStructure2.updateThread = new StructureUpdateThread(rootThreadGroup, j3dStructure2, j3dStructure2.threadType);
                        j3dStructure2.updateThread.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            j3dStructure2.updateThread.initialize();
            j3dStructure2.threadData.thread = j3dStructure2.updateThread;
            j3dStructure2.threadData.lastUpdateTime = Math.max(this.currentTime, j3dStructure2.threadData.lastUpdateTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emptyMessageList(J3dStructure j3dStructure, View view) {
        if (j3dStructure != null) {
            UnorderList unorderList;
            if (view == null) {
                if (j3dStructure.threadData != null) {
                    j3dStructure.threadData.thread = null;
                }
                if (j3dStructure.updateThread != null) {
                    j3dStructure.updateThread.structure = null;
                }
                j3dStructure.updateThread = null;
            }
            boolean bl = false;
            if (view != null && view.universe != null) {
                for (int i = this.views.size() - 1; i >= 0; --i) {
                    if (((View)this.views.get((int)i)).universe != view.universe) continue;
                    bl = true;
                    break;
                }
            }
            UnorderList unorderList2 = unorderList = j3dStructure.messageList;
            synchronized (unorderList2) {
                int n = unorderList.size();
                if (n > 0) {
                    J3dMessage[] j3dMessageArray = (J3dMessage[])unorderList.toArray(false);
                    int n2 = 0;
                    Object var10_10 = null;
                    while (n2 < n) {
                        J3dMessage j3dMessage = j3dMessageArray[n2];
                        if (view == null || j3dMessage.view == view || j3dMessage.view == null && !bl) {
                            if (j3dMessage.type == 0) break;
                            j3dMessage.decRefcount();
                            unorderList.removeOrdered(n2);
                            --n;
                            continue;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private void destroyUpdateThread(J3dStructure j3dStructure) {
        if (j3dStructure.updateThread != null) {
            j3dStructure.updateThread.finish();
            j3dStructure.updateThread.structure = null;
            j3dStructure.updateThread = null;
        }
        j3dStructure.threadData.thread = null;
        j3dStructure.clearMessages();
    }

    private void registerView(View view) {
        final VirtualUniverse virtualUniverse = view.universe;
        if (this.views.contains(view) && this.regUniverseList.contains(virtualUniverse)) {
            return;
        }
        if (this.timerThread == null) {
            this.running = true;
            this.createMCThreads();
        }
        view.assignViewId();
        this.createUpdateThread(virtualUniverse.behaviorStructure);
        this.createUpdateThread(virtualUniverse.geometryStructure);
        this.createUpdateThread(virtualUniverse.soundStructure);
        this.createUpdateThread(virtualUniverse.renderingEnvironmentStructure);
        this.createUpdateThread(virtualUniverse.transformStructure);
        J3dThreadData j3dThreadData = null;
        if (virtualUniverse.behaviorScheduler == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        virtualUniverse.behaviorScheduler = new BehaviorScheduler(rootThreadGroup, virtualUniverse);
                        virtualUniverse.behaviorScheduler.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            virtualUniverse.behaviorScheduler.initialize();
            virtualUniverse.behaviorScheduler.userStop = view.stopBehavior;
            j3dThreadData = virtualUniverse.behaviorScheduler.getThreadData(null, null);
            j3dThreadData.thread = virtualUniverse.behaviorScheduler;
            j3dThreadData.threadType = 1;
            j3dThreadData.lastUpdateTime = Math.max(this.currentTime, j3dThreadData.lastUpdateTime);
        }
        this.createUpdateThread(view.renderBin);
        this.createUpdateThread(view.soundScheduler);
        if (view.physicalEnvironment != null) {
            view.physicalEnvironment.addUser(view);
        }
        this.evaluatePhysicalEnv(view);
        this.regUniverseList.addUnique(virtualUniverse);
        this.views.addUnique(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterView(View view) {
        int n;
        Object object;
        Object object2;
        if (!this.views.remove(view)) {
            view.active = false;
            view.doneUnregister = true;
            return;
        }
        if (view.active) {
            this.viewDeactivate(view);
        }
        view.soundScheduler.updateThread.finish();
        view.renderBin.updateThread.finish();
        view.soundScheduler.updateThread = null;
        view.renderBin.updateThread = null;
        VirtualUniverse virtualUniverse = view.universe;
        Object object3 = this.timeLock;
        synchronized (object3) {
            this.emptyMessageList(view.soundScheduler, view);
            this.emptyMessageList(view.renderBin, view);
            if (virtualUniverse.isEmpty()) {
                this.destroyUniverseThreads(virtualUniverse);
            } else {
                this.emptyMessageList(virtualUniverse.behaviorStructure, view);
                this.emptyMessageList(virtualUniverse.geometryStructure, view);
                this.emptyMessageList(virtualUniverse.soundStructure, view);
                this.emptyMessageList(virtualUniverse.renderingEnvironmentStructure, view);
                this.emptyMessageList(virtualUniverse.transformStructure, view);
            }
        }
        if (view.physicalEnvironment != null) {
            view.physicalEnvironment.removeUser(view);
        }
        object3 = new UnorderList(1, PhysicalEnvironment.class);
        Enumeration<Object> enumeration = PhysicalEnvironment.physicalEnvMap.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (PhysicalEnvironment)enumeration.nextElement();
            object = (InputDeviceScheduler)PhysicalEnvironment.physicalEnvMap.get(object2);
            for (n = ((PhysicalEnvironment)object2).users.size() - 1; n >= 0 && !this.views.contains((View)((PhysicalEnvironment)object2).users.get(n)); --n) {
            }
            if (n >= 0) continue;
            ((J3dThread)object).finish();
            ((PhysicalEnvironment)object2).inputsched = null;
            ((UnorderList)object3).add(object2);
        }
        for (n = ((UnorderList)object3).size() - 1; n >= 0; --n) {
            PhysicalEnvironment.physicalEnvMap.remove(((UnorderList)object3).get(n));
        }
        this.freeContext(view);
        if (this.views.isEmpty()) {
            enumeration = Screen3D.deviceRendererMap.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Renderer)enumeration.nextElement();
                this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                this.runMonitor(6, null, null, null, (J3dThread)object2);
                object = ((Renderer)object2).onScreen;
                if (object != null && ((Screen3D)object).renderer != null) {
                    this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                    this.runMonitor(6, null, null, null, ((Screen3D)object).renderer);
                    ((Screen3D)object).renderer = null;
                }
                if ((object = ((Renderer)object2).offScreen) != null && ((Screen3D)object).renderer != null) {
                    this.rendererCleanupArgs[2] = REMOVEALLCTXS_CLEANUP;
                    this.runMonitor(6, null, null, null, ((Screen3D)object).renderer);
                    ((Screen3D)object).renderer = null;
                }
                ((Renderer)object2).onScreen = null;
                ((Renderer)object2).offScreen = null;
            }
            enumeration = Screen3D.deviceRendererMap.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Renderer)enumeration.nextElement();
                ((Renderer)object2).cleanup();
            }
        } else {
            enumeration = Screen3D.deviceRendererMap.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Renderer)enumeration.nextElement();
                ((J3dThread)object2).cleanupView();
            }
        }
        this.freeMessageList.add(virtualUniverse);
        this.freeMessageList.add(view);
        this.evaluateAllCanvases();
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        this.threadListsChanged = true;
        view.doneUnregister = true;
    }

    void createMCThreads() {
        this.createUpdateThread(this.renderingAttributesStructure);
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.timerThread = new TimerThread(rootThreadGroup);
                    MasterControl.this.timerThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        this.timerThread.start();
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ThreadGroup threadGroup = rootThreadGroup;
                synchronized (threadGroup) {
                    MasterControl.this.notificationThread = new NotificationThread(rootThreadGroup);
                    MasterControl.this.notificationThread.setPriority(threadPriority);
                }
                return null;
            }
        });
        this.notificationThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyUniverseThreads(VirtualUniverse virtualUniverse) {
        if (this.regUniverseList.contains(virtualUniverse)) {
            this.destroyUpdateThread(virtualUniverse.behaviorStructure);
            this.destroyUpdateThread(virtualUniverse.geometryStructure);
            this.destroyUpdateThread(virtualUniverse.soundStructure);
            this.destroyUpdateThread(virtualUniverse.renderingEnvironmentStructure);
            this.destroyUpdateThread(virtualUniverse.transformStructure);
            virtualUniverse.behaviorScheduler.finish();
            virtualUniverse.behaviorScheduler.free();
            virtualUniverse.behaviorScheduler = null;
            virtualUniverse.initMCStructure();
            this.activeUniverseList.remove(virtualUniverse);
            this.regUniverseList.remove(virtualUniverse);
        } else {
            this.emptyMessageList(virtualUniverse.behaviorStructure, null);
            this.emptyMessageList(virtualUniverse.geometryStructure, null);
            this.emptyMessageList(virtualUniverse.soundStructure, null);
            this.emptyMessageList(virtualUniverse.renderingEnvironmentStructure, null);
            this.emptyMessageList(virtualUniverse.transformStructure, null);
        }
        if (this.regUniverseList.isEmpty() && this.views.isEmpty()) {
            if (this.renderingAttributesStructure.updateThread != null) {
                this.renderingAttributesStructure.updateThread.finish();
                this.renderingAttributesStructure.updateThread = null;
            }
            this.renderingAttributesStructure.messageList.clear();
            this.renderingAttributesStructure.objList = new ArrayList();
            this.renderingAttributesStructure = new RenderingAttributesStructure();
            if (this.timerThread != null) {
                this.timerThread.finish();
                this.timerThread = null;
            }
            if (this.notificationThread != null) {
                this.notificationThread.finish();
                this.notificationThread = null;
            }
            Hashtable hashtable = VirtualUniverse.mc.deviceScreenMap;
            synchronized (hashtable) {
                this.deviceScreenMap.clear();
            }
            FreeListManager.clearList(0);
            FreeListManager.clearList(1);
            FreeListManager.clearList(3);
            this.mirrorObjects.clear();
            for (int i = 0; i < this.canvasIds.length; ++i) {
                this.canvasIds[i] = false;
            }
            this.canvasFreeIndex = 0;
            this.renderOnceList.clear();
            this.timestampUpdateList.clear();
            FreeListManager.clearList(2);
            this.defaultRenderMethod = null;
            this.text3DRenderMethod = null;
            this.vertexArrayRenderMethod = null;
            this.displayListRenderMethod = null;
            this.compressedGeometryRenderMethod = null;
            this.orientedShape3DRenderMethod = null;
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateAllCanvases() {
        UnorderList unorderList = this.renderThreadData;
        synchronized (unorderList) {
            Object object;
            int n;
            this.renderThreadData.clear();
            View[] viewArray = (View[])this.views.toArray(false);
            for (n = this.views.size() - 1; n >= 0; --n) {
                viewArray[n].getCanvasList(true);
                object = viewArray[n].getScreens();
                for (int i = ((Screen3D[])object).length - 1; i >= 0; --i) {
                    ((Screen3D)object[i]).canvasCount = 0;
                }
            }
            for (n = this.views.size() - 1; n >= 0; --n) {
                object = viewArray[n];
                Canvas3D[][] canvas3DArray = ((View)object).getCanvasList(false);
                if (!((View)object).active) continue;
                for (int i = canvas3DArray.length - 1; i >= 0; --i) {
                    boolean bl = false;
                    for (int j = canvas3DArray[i].length - 1; j >= 0; --j) {
                        Object object2;
                        Canvas3D canvas3D = canvas3DArray[i][j];
                        final Screen3D screen3D = canvas3D.screen;
                        if (!canvas3D.active) continue;
                        if (screen3D.canvasCount++ == 0 && screen3D.renderer == null) {
                            object2 = (Renderer)Screen3D.deviceRendererMap.get(canvas3D.screen.graphicsDevice);
                            if (object2 == null) {
                                AccessController.doPrivileged(new PrivilegedAction(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public Object run() {
                                        ThreadGroup threadGroup = rootThreadGroup;
                                        synchronized (threadGroup) {
                                            screen3D.renderer = new Renderer(rootThreadGroup);
                                            screen3D.renderer.setPriority(threadPriority);
                                        }
                                        return null;
                                    }
                                });
                                screen3D.renderer.initialize();
                                Screen3D.deviceRendererMap.put(screen3D.graphicsDevice, screen3D.renderer);
                            } else {
                                screen3D.renderer = object2;
                            }
                        }
                        if (canvas3D.offScreen) {
                            screen3D.renderer.offScreen = screen3D;
                            continue;
                        }
                        screen3D.renderer.onScreen = screen3D;
                        if (!bl) {
                            object2 = screen3D.renderer.getThreadData((View)object, null);
                            this.renderThreadData.add(object2);
                            if (((View)object).renderBinReady) {
                                ((J3dThreadData)object2).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object2).lastUpdateTime);
                            }
                            bl = true;
                        }
                        object2 = screen3D.renderer.getThreadData((View)object, canvas3D);
                        this.renderThreadData.add(object2);
                        if (!((View)object).renderBinReady) continue;
                        ((J3dThreadData)object2).lastUpdateTime = Math.max(this.currentTime, ((J3dThreadData)object2).lastUpdateTime);
                    }
                }
            }
        }
        this.threadListsChanged = true;
    }

    private void evaluatePhysicalEnv(View view) {
        final PhysicalEnvironment physicalEnvironment = view.physicalEnvironment;
        if (physicalEnvironment.inputsched == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    ThreadGroup threadGroup = rootThreadGroup;
                    synchronized (threadGroup) {
                        physicalEnvironment.inputsched = new InputDeviceScheduler(rootThreadGroup, physicalEnvironment);
                        physicalEnvironment.inputsched.setPriority(threadPriority);
                    }
                    return null;
                }
            });
            physicalEnvironment.inputsched.start();
            PhysicalEnvironment.physicalEnvMap.put(physicalEnvironment, physicalEnvironment.inputsched);
        }
        this.threadListsChanged = true;
    }

    private final void addToStateThreads(J3dThreadData j3dThreadData) {
        if (j3dThreadData.thread.active) {
            this.stateWorkThreads.add(j3dThreadData);
        }
    }

    private void assignNewPrimaryView(VirtualUniverse virtualUniverse) {
        View view = virtualUniverse.getCurrentView();
        if (view != null) {
            view.primaryView = false;
        }
        View[] viewArray = (View[])this.views.toArray(false);
        int n = this.views.size();
        for (int i = 0; i < n; ++i) {
            View view2 = viewArray[i];
            if (!view2.active || !view2.isRunning || virtualUniverse != view2.universe) continue;
            view2.primaryView = true;
            virtualUniverse.setCurrentView(view2);
            return;
        }
        virtualUniverse.setCurrentView(null);
    }

    RenderMethod getDefaultRenderMethod() {
        if (this.defaultRenderMethod == null) {
            this.defaultRenderMethod = new DefaultRenderMethod();
        }
        return this.defaultRenderMethod;
    }

    RenderMethod getText3DRenderMethod() {
        if (this.text3DRenderMethod == null) {
            this.text3DRenderMethod = new Text3DRenderMethod();
        }
        return this.text3DRenderMethod;
    }

    RenderMethod getVertexArrayRenderMethod() {
        if (this.vertexArrayRenderMethod == null) {
            this.vertexArrayRenderMethod = new VertexArrayRenderMethod();
        }
        return this.vertexArrayRenderMethod;
    }

    RenderMethod getDisplayListRenderMethod() {
        if (this.displayListRenderMethod == null) {
            this.displayListRenderMethod = new DisplayListRenderMethod();
        }
        return this.displayListRenderMethod;
    }

    RenderMethod getCompressedGeometryRenderMethod() {
        if (this.compressedGeometryRenderMethod == null) {
            this.compressedGeometryRenderMethod = new CompressedGeometryRenderMethod();
        }
        return this.compressedGeometryRenderMethod;
    }

    RenderMethod getOrientedShape3DRenderMethod() {
        if (this.orientedShape3DRenderMethod == null) {
            this.orientedShape3DRenderMethod = new OrientedShape3DRenderMethod();
        }
        return this.orientedShape3DRenderMethod;
    }

    private void viewActivate(View view) {
        VirtualUniverse virtualUniverse = view.universe;
        if (virtualUniverse == null) {
            return;
        }
        if (!this.views.contains(view) || !this.regUniverseList.contains(virtualUniverse)) {
            this.registerView(view);
        } else if (view.active) {
            this.evaluateAllCanvases();
            return;
        }
        if (virtualUniverse.activeViewCount == 0) {
            virtualUniverse.geometryStructure.resetConditionMet();
            virtualUniverse.behaviorStructure.resetConditionMet();
        }
        if (view.isRunning) {
            ++this.numActiveViews;
            ++virtualUniverse.activeViewCount;
            this.renderingAttributesStructure.updateThread.active = true;
            virtualUniverse.transformStructure.updateThread.active = true;
            virtualUniverse.geometryStructure.updateThread.active = true;
            virtualUniverse.soundStructure.updateThread.active = true;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
        }
        virtualUniverse.behaviorScheduler.active = true;
        virtualUniverse.behaviorStructure.updateThread.active = true;
        this.activeUniverseList.addUnique(virtualUniverse);
        if (view.isRunning) {
            view.soundScheduler.activate();
            view.renderBin.updateThread.active = true;
        }
        view.active = true;
        if (view.physicalEnvironment.activeViewRef++ == 0) {
            view.physicalEnvironment.inputsched.activate();
        }
        if (virtualUniverse.getCurrentView() == null) {
            this.assignNewPrimaryView(virtualUniverse);
        }
        this.evaluateAllCanvases();
        view.inRenderThreadData = true;
        this.threadListsChanged = true;
        view.renderBin.reactivateView = true;
    }

    private void freeContext(View view) {
        Canvas3D[][] canvas3DArray = view.getCanvasList(false);
        for (int i = canvas3DArray.length - 1; i >= 0; --i) {
            for (int j = canvas3DArray[i].length - 1; j >= 0; --j) {
                Canvas3D canvas3D = canvas3DArray[i][j];
                if (canvas3D.validCanvas || canvas3D.screen == null || canvas3D.screen.renderer == null) continue;
                this.rendererCleanupArgs[1] = canvas3D;
                this.rendererCleanupArgs[2] = FREECONTEXT_CLEANUP;
                this.runMonitor(6, null, null, null, canvas3D.screen.renderer);
                this.rendererCleanupArgs[1] = null;
            }
        }
    }

    private void viewDeactivate(View view) {
        if (!this.views.contains(view) || !view.active) {
            view.active = false;
            this.evaluateAllCanvases();
            return;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (view.isRunning) {
            --this.numActiveViews;
            --virtualUniverse.activeViewCount;
        }
        if (this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        if (virtualUniverse.activeViewCount == 0 && virtualUniverse.behaviorScheduler != null) {
            virtualUniverse.behaviorScheduler.deactivate();
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.behaviorStructure.updateThread.active = false;
            virtualUniverse.soundStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
            this.activeUniverseList.remove(virtualUniverse);
        }
        view.soundScheduler.deactivate();
        view.renderBin.updateThread.active = false;
        view.active = false;
        if (--view.physicalEnvironment.activeViewRef == 0) {
            view.physicalEnvironment.inputsched.deactivate();
        }
        this.assignNewPrimaryView(virtualUniverse);
        this.evaluateAllCanvases();
        this.freeContext(view);
        view.inRenderThreadData = false;
        this.threadListsChanged = true;
    }

    private void startView(View view) {
        if (!this.views.contains(view) || view.isRunning || !view.active) {
            view.isRunning = true;
            return;
        }
        ++this.numActiveViews;
        this.renderingAttributesStructure.updateThread.active = true;
        VirtualUniverse virtualUniverse = view.universe;
        ++virtualUniverse.activeViewCount;
        virtualUniverse.transformStructure.updateThread.active = true;
        virtualUniverse.geometryStructure.updateThread.active = true;
        virtualUniverse.soundStructure.updateThread.active = true;
        virtualUniverse.renderingEnvironmentStructure.updateThread.active = true;
        view.renderBin.updateThread.active = true;
        view.soundScheduler.activate();
        view.isRunning = true;
        if (virtualUniverse.getCurrentView() == null) {
            this.assignNewPrimaryView(virtualUniverse);
        }
        this.threadListsChanged = true;
    }

    private void stopView(View view) {
        if (!(this.views.contains(view) && view.isRunning && view.active)) {
            view.isRunning = false;
            return;
        }
        if (--this.numActiveViews == 0) {
            this.renderingAttributesStructure.updateThread.active = false;
        }
        VirtualUniverse virtualUniverse = view.universe;
        if (--virtualUniverse.activeViewCount == 0) {
            virtualUniverse.transformStructure.updateThread.active = false;
            virtualUniverse.geometryStructure.updateThread.active = false;
            virtualUniverse.renderingEnvironmentStructure.updateThread.active = false;
            virtualUniverse.soundStructure.updateThread.active = false;
        }
        view.renderBin.updateThread.active = false;
        view.soundScheduler.deactivate();
        view.isRunning = false;
        this.assignNewPrimaryView(virtualUniverse);
        this.threadListsChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        UnorderList unorderList = this.inputDeviceThreads;
        synchronized (unorderList) {
            this.inputDeviceThreads.add(inputDeviceScheduler);
            if (this.inputDeviceThreads.size() == 1) {
                this.timerThread.addInputDeviceSchedCond();
            }
        }
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void removeInputDeviceScheduler(InputDeviceScheduler inputDeviceScheduler) {
        this.inputDeviceThreads.remove(inputDeviceScheduler);
        this.postRequest(INPUTDEVICE_CHANGE, null);
    }

    void addMirrorObject(ObjectUpdate objectUpdate) {
        this.mirrorObjects.add(objectUpdate);
    }

    void updateMirrorObjects() {
        ObjectUpdate[] objectUpdateArray = (ObjectUpdate[])this.mirrorObjects.toArray(false);
        int n = this.mirrorObjects.arraySize();
        for (int i = 0; i < n; ++i) {
            objectUpdateArray[i].updateObject();
        }
        this.mirrorObjects.clear();
    }

    private void updateWorkThreads() {
        J3dThreadData j3dThreadData;
        Canvas3D[][] canvas3DArray;
        Object object;
        View[] viewArray;
        int n;
        this.stateWorkThreads.clear();
        this.renderWorkThreads.clear();
        this.requestRenderWorkThreads.clear();
        if (this.numActiveViews > 0) {
            this.addToStateThreads(this.renderingAttributesStructure.getUpdateThreadData());
        }
        VirtualUniverse[] virtualUniverseArray = (VirtualUniverse[])this.activeUniverseList.toArray(false);
        int n2 = this.activeUniverseList.arraySize();
        for (n = n2 - 1; n >= 0; --n) {
            this.addToStateThreads(virtualUniverseArray[n].transformStructure.getUpdateThreadData());
        }
        this.lastTransformStructureThread = this.stateWorkThreads.size();
        for (n = n2 - 1; n >= 0; --n) {
            VirtualUniverse virtualUniverse = virtualUniverseArray[n];
            this.addToStateThreads(virtualUniverse.geometryStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.behaviorStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.renderingEnvironmentStructure.getUpdateThreadData());
            this.addToStateThreads(virtualUniverse.soundStructure.getUpdateThreadData());
        }
        this.lastStructureUpdateThread = this.stateWorkThreads.size();
        for (n = n2 - 1; n >= 0; --n) {
            this.addToStateThreads(virtualUniverseArray[n].behaviorScheduler.getThreadData(null, null));
        }
        InputDeviceScheduler[] inputDeviceSchedulerArray = (InputDeviceScheduler[])this.inputDeviceThreads.toArray(true);
        for (n = this.inputDeviceThreads.size() - 1; n >= 0; --n) {
            viewArray = inputDeviceSchedulerArray[n].getThreadData();
            viewArray.thread.active = true;
            this.addToStateThreads((J3dThreadData)viewArray);
        }
        viewArray = (View[])this.views.toArray(false);
        for (n = this.views.size() - 1; n >= 0; --n) {
            Canvas3D canvas3D;
            int n3;
            int n4;
            object = viewArray[n];
            if (!((View)object).active || !((View)object).isRunning) continue;
            this.addToStateThreads(((View)object).renderBin.getUpdateThreadData());
            this.addToStateThreads(((View)object).soundScheduler.getUpdateThreadData());
            canvas3DArray = ((View)object).getCanvasList(false);
            int n5 = ((View)object).getLongestScreenList();
            Object[] objectArray = null;
            for (n4 = 0; n4 < n5; ++n4) {
                for (n3 = 0; n3 < canvas3DArray.length; ++n3) {
                    if (n4 >= canvas3DArray[n3].length) continue;
                    canvas3D = canvas3DArray[n3][n4];
                    if (!canvas3D.active || !canvas3D.isRunningStatus || canvas3D.offScreen || canvas3D.screen.renderer == null) continue;
                    j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, canvas3D);
                    this.renderWorkThreads.add(j3dThreadData);
                    objectArray = (Object[])j3dThreadData.threadArgs;
                    objectArray[0] = RENDER;
                    objectArray[1] = canvas3D;
                    objectArray[2] = object;
                }
            }
            block7: for (n4 = 0; n4 < canvas3DArray.length; ++n4) {
                for (n3 = 0; n3 < canvas3DArray[n4].length; ++n3) {
                    canvas3D = canvas3DArray[n4][n3];
                    if (!canvas3D.active || !canvas3D.isRunningStatus || canvas3D.offScreen || canvas3D.screen.renderer == null) continue;
                    j3dThreadData = canvas3D.screen.renderer.getThreadData((View)object, null);
                    this.renderWorkThreads.add(j3dThreadData);
                    objectArray = (Object[])j3dThreadData.threadArgs;
                    objectArray[0] = SWAP;
                    objectArray[1] = object;
                    objectArray[2] = canvas3DArray[n4];
                    continue block7;
                }
            }
        }
        j3dThreadData = null;
        object = Screen3D.deviceRendererMap.elements();
        while (object.hasMoreElements()) {
            canvas3DArray = (Canvas3D[][])object.nextElement();
            j3dThreadData = canvas3DArray.getThreadData(null, null);
            this.requestRenderWorkThreads.add(j3dThreadData);
            j3dThreadData.threadOpts = 2;
            ((Object[])j3dThreadData.threadArgs)[0] = REQUESTRENDER;
        }
        if (j3dThreadData != null) {
            j3dThreadData.threadOpts |= 1;
        }
        this.threadListsChanged = false;
    }

    void dumpWorkThreads() {
        System.err.println("-----------------------------");
        System.err.println("MasterControl/dumpWorkThreads");
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            J3dThreadData[] j3dThreadDataArray;
            switch (i) {
                case 0: {
                    j3dThreadDataArray = (J3dThreadData[])this.stateWorkThreads.toArray(false);
                    n = this.stateWorkThreads.arraySize();
                    break;
                }
                case 1: {
                    j3dThreadDataArray = (J3dThreadData[])this.renderWorkThreads.toArray(false);
                    n = this.renderWorkThreads.arraySize();
                    break;
                }
                default: {
                    j3dThreadDataArray = (J3dThreadData[])this.requestRenderWorkThreads.toArray(false);
                    n = this.requestRenderWorkThreads.arraySize();
                }
            }
            for (int j = 0; j < n; ++j) {
                J3dThreadData j3dThreadData = j3dThreadDataArray[j];
                System.err.println("Thread " + j + ": " + j3dThreadData.thread);
                System.err.println("\tOps: " + j3dThreadData.threadOpts);
                if (j3dThreadData.threadArgs != null) {
                    Object[] objectArray = (Object[])j3dThreadData.threadArgs;
                    System.err.print("\tArgs: ");
                    for (int k = 0; k < objectArray.length; ++k) {
                        System.err.print(objectArray[k] + " ");
                    }
                }
                System.err.println("");
            }
        }
        System.err.println("-----------------------------");
    }

    final void setWork() {
        this.runMonitor(1, null, null, null, null);
    }

    final void setWorkForRequestRenderer() {
        this.runMonitor(5, null, null, null, null);
    }

    void sendRenderMessage(GraphicsConfiguration graphicsConfiguration, Object object, Integer n) {
        Renderer renderer = this.createRenderer(graphicsConfiguration);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 16;
        j3dMessage.type = 44;
        j3dMessage.universe = null;
        j3dMessage.view = null;
        j3dMessage.args[0] = null;
        j3dMessage.args[1] = object;
        j3dMessage.args[2] = n;
        renderer.rendererStructure.addMessage(j3dMessage);
        this.setWorkForRequestRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendDestroyCtxAndOffScreenBuffer(Canvas3D canvas3D) {
        GraphicsDevice graphicsDevice = canvas3D.graphicsConfiguration.getDevice();
        J3dDebug.doAssert(Screen3D.deviceRendererMap.get(graphicsDevice) != null, "Screen3D.deviceRendererMap.get(gd) != null");
        Object object = mcThreadLock;
        synchronized (object) {
            J3dDebug.doAssert(this.mcThread != null, "mcThread != null");
            Renderer renderer = this.createRenderer(canvas3D.graphicsConfiguration);
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 62;
            j3dMessage.universe = null;
            j3dMessage.view = null;
            j3dMessage.args[0] = canvas3D;
            renderer.rendererStructure.addMessage(j3dMessage);
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                this.setWorkForRequestRenderer();
                this.pendingRequest = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCreateOffScreenBuffer(Canvas3D canvas3D) {
        GraphicsDevice graphicsDevice = canvas3D.graphicsConfiguration.getDevice();
        J3dDebug.doAssert(Screen3D.deviceRendererMap.get(graphicsDevice) != null, "Screen3D.deviceRendererMap.get(gd) != null");
        Object object = mcThreadLock;
        synchronized (object) {
            if (this.mcThread == null) {
                this.createMasterControlThread();
            }
            Renderer renderer = this.createRenderer(canvas3D.graphicsConfiguration);
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 61;
            j3dMessage.universe = null;
            j3dMessage.view = null;
            j3dMessage.args[0] = canvas3D;
            renderer.rendererStructure.addMessage(j3dMessage);
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                this.setWorkForRequestRenderer();
                this.pendingRequest = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork() {
        this.runMonitor(0, null, null, null, null);
        View[] viewArray = this.timeLock;
        synchronized (this.timeLock) {
            UnorderList unorderList = this.requestObjList;
            synchronized (unorderList) {
                if (this.pendingRequest) {
                    this.handlePendingRequest();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!this.running) {
                return;
            }
            if (this.threadListsChanged) {
                this.updateWorkThreads();
            }
            viewArray = this.timeLock;
            synchronized (viewArray) {
                this.updateTimeValues();
            }
            viewArray = (View[])this.views.toArray(false);
            for (int i = this.views.size() - 1; i >= 0; --i) {
                if (!viewArray[i].active) continue;
                viewArray[i].updateViewCache();
                if ((viewArray[i].viewCache.vcDirtyMask == 0 || viewArray[i].renderBin.orientedRAs.isEmpty()) && (viewArray[i].renderBin.cachedDirtyOrientedRAs == null || viewArray[i].renderBin.cachedDirtyOrientedRAs.isEmpty())) continue;
                viewArray[i].renderBin.updateOrientedRAs();
            }
            this.runMonitor(2, this.stateWorkThreads, this.renderWorkThreads, this.requestRenderWorkThreads, null);
            if (this.renderOnceList.size() > 0) {
                this.clearRenderOnceList();
            }
            this.manageMemory();
            return;
        }
    }

    private void handlePendingRequest() {
        Object object;
        Object object2;
        int n;
        boolean bl = false;
        Object[] objectArray = this.requestObjList.toArray(false);
        Integer[] integerArray = (Integer[])this.requestTypeList.toArray(false);
        int n2 = this.requestObjList.size();
        for (n = 0; n < n2; ++n) {
            object2 = integerArray[n];
            object = objectArray[n];
            if (object2 == RESET_CANVAS) {
                Canvas3D canvas3D = (Canvas3D)object;
                if (canvas3D.screen != null && canvas3D.screen.renderer != null) {
                    this.rendererCleanupArgs[1] = object;
                    this.rendererCleanupArgs[2] = RESETCANVAS_CLEANUP;
                    this.runMonitor(6, null, null, null, canvas3D.screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
                canvas3D.reset();
                canvas3D.view = null;
                canvas3D.computeViewCache();
                continue;
            }
            if (object2 == ACTIVATE_VIEW) {
                this.viewActivate((View)object);
                continue;
            }
            if (object2 == DEACTIVATE_VIEW) {
                this.viewDeactivate((View)object);
                continue;
            }
            if (object2 == REEVALUATE_CANVAS) {
                this.evaluateAllCanvases();
                continue;
            }
            if (object2 == INPUTDEVICE_CHANGE) {
                this.inputDeviceThreads.clearMirror();
                this.threadListsChanged = true;
                continue;
            }
            if (object2 == START_VIEW) {
                this.startView((View)object);
                continue;
            }
            if (object2 == STOP_VIEW) {
                View view = (View)object;
                if (++view.stopViewCount > 4) {
                    view.stopViewCount = -1;
                    this.stopView(view);
                    continue;
                }
                this.tempViewList.add(view);
                continue;
            }
            if (object2 == UNREGISTER_VIEW) {
                this.unregisterView((View)object);
                continue;
            }
            if (object2 == PHYSICAL_ENV_CHANGE) {
                this.evaluatePhysicalEnv((View)object);
                continue;
            }
            if (object2 == EMPTY_UNIVERSE) {
                boolean bl2 = false;
                VirtualUniverse virtualUniverse = (VirtualUniverse)object;
                View[] viewArray = (View[])this.views.toArray(false);
                for (int i = this.views.size() - 1; i >= 0; --i) {
                    if (viewArray[i].universe != virtualUniverse) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                this.destroyUniverseThreads(virtualUniverse);
                this.threadListsChanged = true;
                continue;
            }
            if (object2 == START_RENDERER) {
                ((Canvas3D)object).isRunningStatus = true;
                this.threadListsChanged = true;
                continue;
            }
            if (object2 == STOP_RENDERER) {
                if (object instanceof Canvas3D) {
                    ((Canvas3D)object).isRunningStatus = false;
                } else {
                    ((Renderer)object).userStop = true;
                }
                this.threadListsChanged = true;
                continue;
            }
            if (object2 == RENDER_ONCE) {
                View view = (View)object;
                this.startView(view);
                this.renderOnceList.add(view);
                this.sendRunMessage(view, 128);
                this.threadListsChanged = true;
                bl = true;
                continue;
            }
            if (object2 == FREE_CONTEXT) {
                Canvas3D canvas3D = (Canvas3D)((Object[])object)[0];
                if (canvas3D.screen != null && canvas3D.screen.renderer != null) {
                    this.rendererCleanupArgs[1] = object;
                    this.rendererCleanupArgs[2] = REMOVECTX_CLEANUP;
                    this.runMonitor(6, null, null, null, canvas3D.screen.renderer);
                    this.rendererCleanupArgs[1] = null;
                }
                bl = true;
                continue;
            }
            if (object2 == FREE_DRAWING_SURFACE) {
                DrawingSurfaceObjectAWT.freeDrawingSurface(object);
                continue;
            }
            if (object2 == GETBESTCONFIG) {
                GraphicsConfiguration graphicsConfiguration = ((GraphicsConfiguration[])((GraphicsConfigTemplate3D)object).testCfg)[0];
                this.sendRenderMessage(graphicsConfiguration, object, (Integer)object2);
                bl = true;
                continue;
            }
            if (object2 == ISCONFIGSUPPORT) {
                GraphicsConfiguration graphicsConfiguration = (GraphicsConfiguration)((GraphicsConfigTemplate3D)object).testCfg;
                this.sendRenderMessage(graphicsConfiguration, object, (Integer)object2);
                bl = true;
                continue;
            }
            if (object2 == SET_GRAPHICSCONFIG_FEATURES || object2 == SET_QUERYPROPERTIES) {
                GraphicsConfiguration graphicsConfiguration = ((Canvas3D)object).graphicsConfiguration;
                this.sendRenderMessage(graphicsConfiguration, object, (Integer)object2);
                bl = true;
                continue;
            }
            if (object2 != SET_VIEW) continue;
            Canvas3D canvas3D = (Canvas3D)object;
            canvas3D.view = canvas3D.pendingView;
            canvas3D.computeViewCache();
        }
        for (n = 0; n < n2; ++n) {
            object2 = integerArray[n];
            if (object2 != FREE_MESSAGE) continue;
            if (objectArray[n] instanceof VirtualUniverse) {
                object = (VirtualUniverse)objectArray[n];
                if (this.regUniverseList.contains(object)) continue;
                this.emptyMessageList(((VirtualUniverse)object).behaviorStructure, null);
                this.emptyMessageList(((VirtualUniverse)object).geometryStructure, null);
                this.emptyMessageList(((VirtualUniverse)object).soundStructure, null);
                this.emptyMessageList(((VirtualUniverse)object).renderingEnvironmentStructure, null);
                continue;
            }
            if (!(objectArray[n] instanceof View) || this.views.contains(object = (View)objectArray[n])) continue;
            this.emptyMessageList(((View)object).soundScheduler, (View)object);
            this.emptyMessageList(((View)object).renderBin, (View)object);
            if (((View)object).resetUnivCount != ((View)object).universeCount) continue;
            ((View)object).reset();
            ((View)object).universe = null;
            if (this.running) continue;
        }
        this.requestObjList.clear();
        this.requestTypeList.clear();
        n2 = this.tempViewList.size();
        if (n2 > 0) {
            if (this.running) {
                for (n = 0; n < n2; ++n) {
                    this.requestTypeList.add(STOP_VIEW);
                    this.requestObjList.add(this.tempViewList.get(n));
                }
                this.setWork();
            } else {
                for (n = 0; n < n2; ++n) {
                    object2 = (View)this.tempViewList.get(n);
                    ((View)object2).stopViewCount = -1;
                    ((View)object2).isRunning = false;
                }
            }
            this.tempViewList.clear();
            this.pendingRequest = true;
        } else {
            this.pendingRequest = bl || this.requestObjList.size() > 0;
        }
        n2 = this.freeMessageList.size();
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                this.requestTypeList.add(FREE_MESSAGE);
                this.requestObjList.add(this.freeMessageList.get(n));
            }
            this.pendingRequest = true;
            this.freeMessageList.clear();
        }
        if (!this.running && this.renderOnceList.size() > 0) {
            this.clearRenderOnceList();
        }
        if (this.pendingRequest) {
            this.setWork();
        }
        if (bl || this.requestRenderWorkToDo) {
            this.running = true;
        }
    }

    private void clearRenderOnceList() {
        for (int i = this.renderOnceList.size() - 1; i >= 0; --i) {
            View view = (View)this.renderOnceList.get(i);
            view.renderOnceFinish = true;
            this.stopView(view);
        }
        this.renderOnceList.clear();
        this.threadListsChanged = true;
    }

    synchronized void runMonitor(int n, UnorderList unorderList, UnorderList unorderList2, UnorderList unorderList3, J3dThread j3dThread) {
        switch (n) {
            case 2: {
                View view;
                int n2;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                J3dThreadData[] j3dThreadDataArray = (J3dThreadData[])unorderList2.toArray(false);
                J3dThreadData[] j3dThreadDataArray2 = (J3dThreadData[])unorderList.toArray(false);
                J3dThreadData[] j3dThreadDataArray3 = (J3dThreadData[])unorderList3.toArray(false);
                int n6 = unorderList2.arraySize();
                int n7 = unorderList.arraySize();
                int n8 = unorderList3.arraySize();
                boolean bl = false;
                View[] viewArray = (View[])this.views.toArray(false);
                if (this.lockGeometry) {
                    for (n2 = this.views.arraySize() - 1; n2 >= 0; --n2) {
                        view = viewArray[n2];
                        view.renderBin.lockGeometry();
                    }
                }
                while (!bl) {
                    J3dThreadData j3dThreadData;
                    while (!this.renderWaiting && n4 != n6) {
                        View view2;
                        j3dThreadData = j3dThreadDataArray[n4++];
                        if (!j3dThreadData.needsRun) continue;
                        if ((j3dThreadData.threadOpts & 8) != 0) {
                            view2 = (View)((Object[])j3dThreadData.threadArgs)[2];
                            ++view2.frameNumber;
                            view2.startTime = J3dClock.currentTimeMillis();
                        }
                        ++this.renderPending;
                        if (this.cpuLimit == 1) {
                            j3dThreadData.thread.args = (Object[])j3dThreadData.threadArgs;
                            j3dThreadData.thread.doWork(this.currentTime);
                        } else {
                            ++this.threadPending;
                            j3dThreadData.thread.runMonitor(2, this.currentTime, (Object[])j3dThreadData.threadArgs);
                        }
                        if ((j3dThreadData.threadOpts & 0x10) != 0) {
                            view2 = (View)((Object[])j3dThreadData.threadArgs)[3];
                            this.timestampUpdateList.add(view2);
                        }
                        if ((j3dThreadData.threadOpts & 0x20) != 0) {
                            for (n2 = 0; n2 < this.views.arraySize(); ++n2) {
                                view = viewArray[n2];
                                view.renderBin.releaseGeometry();
                            }
                        }
                        if (this.cpuLimit != 1 && (j3dThreadData.threadOpts & 1) != 0) {
                            this.renderWaiting = true;
                        }
                        if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                        this.state = 4;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println(interruptedException);
                        }
                        this.state = 1;
                    }
                    while (!this.stateWaiting && n3 != n7) {
                        j3dThreadData = j3dThreadDataArray2[n3++];
                        if (!j3dThreadData.needsRun) continue;
                        ++this.statePending;
                        if (this.cpuLimit == 1) {
                            j3dThreadData.thread.args = (Object[])j3dThreadData.threadArgs;
                            j3dThreadData.thread.doWork(this.currentTime);
                        } else {
                            ++this.threadPending;
                            j3dThreadData.thread.runMonitor(2, this.currentTime, (Object[])j3dThreadData.threadArgs);
                        }
                        if (this.cpuLimit != 1 && (j3dThreadData.threadOpts & 1) != 0) {
                            this.stateWaiting = true;
                        }
                        if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                        if (n4 != n6) break;
                        this.state = 4;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            System.err.println(interruptedException);
                        }
                        this.state = 1;
                    }
                    if (!this.renderWaiting && n4 == n6) {
                        n5 = 0;
                        while (!this.renderWaiting && n5 != n8) {
                            j3dThreadData = j3dThreadDataArray3[n5++];
                            ++this.renderPending;
                            if (this.cpuLimit == 1) {
                                j3dThreadData.thread.args = (Object[])j3dThreadData.threadArgs;
                                j3dThreadData.thread.doWork(this.currentTime);
                            } else {
                                ++this.threadPending;
                                j3dThreadData.thread.runMonitor(2, this.currentTime, (Object[])j3dThreadData.threadArgs);
                            }
                            if (this.cpuLimit != 1 && (j3dThreadData.threadOpts & 1) != 0) {
                                this.renderWaiting = true;
                            }
                            if (this.cpuLimit == 1 || this.cpuLimit > this.threadPending) continue;
                            this.state = 4;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                System.err.println(interruptedException);
                            }
                            this.state = 1;
                        }
                    }
                    if (this.cpuLimit != 1 && (this.renderWaiting && n3 == n7 || this.stateWaiting && n4 == n6 || this.renderWaiting && this.stateWaiting)) {
                        if (!this.requestRenderWorkToDo) {
                            this.state = 3;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                System.err.println(interruptedException);
                            }
                            this.state = 1;
                        }
                        this.requestRenderWorkToDo = false;
                    }
                    if (n3 != n7 || n4 != n6 || n5 != n8 || this.threadPending != 0) continue;
                    for (int i = this.timestampUpdateList.size() - 1; i >= 0; --i) {
                        View view3 = (View)this.timestampUpdateList.get(i);
                        view3.setFrameTimingValues();
                        view3.universe.behaviorStructure.incElapsedFrames();
                    }
                    this.timestampUpdateList.clear();
                    this.updateMirrorObjects();
                    bl = true;
                }
                break;
            }
            case 3: {
                if (this.state != 5) {
                    --this.threadPending;
                    if (j3dThread.type == 16) {
                        View view = (View)j3dThread.args[3];
                        if (view != null) {
                            view.stopTime = J3dClock.currentTimeMillis();
                        }
                        if (--this.renderPending == 0) {
                            this.renderWaiting = false;
                        }
                    } else if (--this.statePending == 0) {
                        this.stateWaiting = false;
                    }
                    if (this.state != 4 && this.state != 3) break;
                    this.notify();
                    break;
                }
                this.notify();
                this.state = 1;
                break;
            }
            case 4: {
                while (this.threadPending != 0) {
                    this.state = 3;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println(interruptedException);
                    }
                }
                break;
            }
            case 0: {
                if (!this.workToDo) {
                    this.state = 0;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        System.err.println(interruptedException);
                    }
                    this.state = 1;
                }
                this.workToDo = false;
                break;
            }
            case 1: {
                this.workToDo = true;
                if (this.state != 0) break;
                this.notify();
                break;
            }
            case 5: {
                this.requestRenderWorkToDo = true;
                this.workToDo = true;
                if (this.state != 4 && this.state != 3 && this.state != 0) break;
                this.notify();
                break;
            }
            case 6: {
                j3dThread.runMonitor(2, this.currentTime, this.rendererCleanupArgs);
                this.state = 5;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
                break;
            }
            case 7: {
                this.state = 0;
                try {
                    this.wait(this.sleepTime);
                    break;
                }
                catch (InterruptedException interruptedException) {
                    System.err.println(interruptedException);
                }
            }
        }
    }

    static void dumpThreads(int n) {
        if ((n & 1) != 0) {
            System.out.println("  BEHAVIOR_SCHEDULER");
        }
        if ((n & 2) != 0) {
            System.out.println("  SOUND_SCHEDULER");
        }
        if ((n & 4) != 0) {
            System.out.println("  INPUT_DEVICE_SCHEDULER");
        }
        if ((n & 0x10) != 0) {
            System.out.println("  RENDER_THREAD");
        }
        if ((n & 0x40) != 0) {
            System.out.println("  UPDATE_GEOMETRY");
        }
        if ((n & 0x80) != 0) {
            System.out.println("  UPDATE_RENDER");
        }
        if ((n & 0x100) != 0) {
            System.out.println("  UPDATE_BEHAVIOR");
        }
        if ((n & 0x200) != 0) {
            System.out.println("  UPDATE_SOUND");
        }
        if ((n & 0x400) != 0) {
            System.out.println("  UPDATE_RENDERING_ATTRIBUTES");
        }
        if ((n & 0x1000) != 0) {
            System.out.println("  UPDATE_RENDERING_ENVIRONMENT");
        }
        if ((n & 0x2000) != 0) {
            System.out.println("  UPDATE_TRANSFORM");
        }
    }

    static void dumpmsg(J3dMessage j3dMessage) {
        System.out.println(mtype[j3dMessage.type]);
        MasterControl.dumpThreads(j3dMessage.threads);
    }

    private void manageMemory() {
        if (++this.frameCount > this.frameCountCutoff) {
            FreeListManager.manageLists();
            this.frameCount = 0;
        }
    }

    static final void threadYield() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        $assertionsDisabled = !MasterControl.class.desiredAssertionStatus();
        REQUESTRENDER = new Integer(2);
        RENDER = new Integer(0);
        SWAP = new Integer(1);
        ACTIVATE_VIEW = new Integer(1);
        DEACTIVATE_VIEW = new Integer(2);
        START_VIEW = new Integer(3);
        STOP_VIEW = new Integer(4);
        REEVALUATE_CANVAS = new Integer(5);
        UNREGISTER_VIEW = new Integer(6);
        PHYSICAL_ENV_CHANGE = new Integer(7);
        INPUTDEVICE_CHANGE = new Integer(8);
        EMPTY_UNIVERSE = new Integer(9);
        START_RENDERER = new Integer(10);
        STOP_RENDERER = new Integer(11);
        RENDER_ONCE = new Integer(12);
        FREE_CONTEXT = new Integer(13);
        FREE_DRAWING_SURFACE = new Integer(14);
        FREE_MESSAGE = new Integer(15);
        RESET_CANVAS = new Integer(16);
        GETBESTCONFIG = new Integer(17);
        ISCONFIGSUPPORT = new Integer(18);
        SET_GRAPHICSCONFIG_FEATURES = new Integer(19);
        SET_QUERYPROPERTIES = new Integer(20);
        SET_VIEW = new Integer(21);
        librariesLoaded = false;
        systemStartTime = 0L;
        isD3DAPI = false;
        isWin32 = false;
        globalShadingLanguage = 1;
        cgLibraryAvailable = false;
        glslLibraryAvailable = false;
        REMOVEALLCTXS_CLEANUP = new Integer(1);
        REMOVECTX_CLEANUP = new Integer(2);
        REMOVENOTIFY_CLEANUP = new Integer(3);
        RESETCANVAS_CLEANUP = new Integer(4);
        FREECONTEXT_CLEANUP = new Integer(5);
        mcThreadLock = new Object();
        systemPathProps = new String[]{"sun.boot.library.path", "java.library.path"};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ThreadGroup threadGroup;
                Thread thread = Thread.currentThread();
                threadPriority = thread.getPriority();
                rootThreadGroup = thread.getThreadGroup();
                while ((threadGroup = rootThreadGroup.getParent()) != null) {
                    rootThreadGroup = threadGroup;
                }
                rootThreadGroup = new ThreadGroup(rootThreadGroup, "Java3D");
                return null;
            }
        });
        mtype = new String[]{"-INSERT_NODES                   ", "-REMOVE_NODES                   ", "-RUN                            ", "-TRANSFORM_CHANGED              ", "-UPDATE_VIEW                    ", "-STOP_THREAD                    ", "-COLORINGATTRIBUTES_CHANGED     ", "-LINEATTRIBUTES_CHANGED         ", "-POINTATTRIBUTES_CHANGED        ", "-POLYGONATTRIBUTES_CHANGED      ", "-RENDERINGATTRIBUTES_CHANGED    ", "-TEXTUREATTRIBUTES_CHANGED      ", "-TRANSPARENCYATTRIBUTES_CHANGED ", "-MATERIAL_CHANGED               ", "-TEXCOORDGENERATION_CHANGED     ", "-TEXTURE_CHANGED                ", "-MORPH_CHANGED                  ", "-GEOMETRY_CHANGED               ", "-APPEARANCE_CHANGED             ", "-LIGHT_CHANGED                  ", "-BACKGROUND_CHANGED             ", "-CLIP_CHANGED                   ", "-FOG_CHANGED                    ", "-BOUNDINGLEAF_CHANGED           ", "-SHAPE3D_CHANGED                ", "-TEXT3D_TRANSFORM_CHANGED       ", "-TEXT3D_DATA_CHANGED            ", "-SWITCH_CHANGED                 ", "-COND_MET                       ", "-BEHAVIOR_ENABLE                ", "-BEHAVIOR_DISABLE               ", "-INSERT_RENDERATOMS             ", "-ORDERED_GROUP_INSERTED         ", "-ORDERED_GROUP_REMOVED          ", "-COLLISION_BOUND_CHANGED        ", "-REGION_BOUND_CHANGED           ", "-MODELCLIP_CHANGED              ", "-BOUNDS_AUTO_COMPUTE_CHANGED    ", "-SOUND_ATTRIB_CHANGED           ", "-AURALATTRIBUTES_CHANGED        ", "-SOUNDSCAPE_CHANGED             ", "-ALTERNATEAPPEARANCE_CHANGED    ", "-RENDER_OFFSCREEN               ", "-RENDER_RETAINED                ", "-RENDER_IMMEDIATE               ", "-SOUND_STATE_CHANGED            ", "-ORIENTEDSHAPE3D_CHANGED        ", "-TEXTURE_UNIT_STATE_CHANGED     ", "-UPDATE_VIEWPLATFORM            ", "-BEHAVIOR_ACTIVATE              ", "-GEOMETRYARRAY_CHANGED          ", "-MEDIA_CONTAINER_CHANGED        ", "-RESIZE_CANVAS                  ", "-TOGGLE_CANVAS                  ", "-IMAGE_COMPONENT_CHANGED        ", "-SCHEDULING_INTERVAL_CHANGED    ", "-VIEWSPECIFICGROUP_CHANGED      ", "-VIEWSPECIFICGROUP_INIT         ", "-VIEWSPECIFICGROUP_CLEAR        ", "-ORDERED_GROUP_TABLE_CHANGED"};
    }
}

