/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Behavior;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.IndexedUnorderSet;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dThread;
import javax.media.j3d.MasterControl;
import javax.media.j3d.UnorderList;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriteriaEnumerator;

class BehaviorScheduler
extends J3dThread {
    VirtualUniverse univ = null;
    UnorderList[] processList;
    IndexedUnorderSet scheduleList;
    BehaviorStructure behaviorStructure;
    int stopCount = -1;
    long lastStartTime;
    long lastStopTime;
    Object intervalTimeLock = new Object();
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    BehaviorScheduler(ThreadGroup threadGroup, VirtualUniverse virtualUniverse) {
        super(threadGroup);
        this.setName("J3D-BehaviorScheduler-" + this.getInstanceNum());
        this.univ = virtualUniverse;
        this.behaviorStructure = virtualUniverse.behaviorStructure;
        this.scheduleList = this.behaviorStructure.scheduleList;
        this.processList = this.behaviorStructure.processList;
        this.type = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopBehaviorScheduler(long[] lArray) {
        this.stopCount = 2;
        VirtualUniverse.mc.sendRunMessage(this.univ, 1);
        while (!this.userStop) {
            MasterControl.threadYield();
        }
        Object object = this.intervalTimeLock;
        synchronized (object) {
            lArray[0] = this.lastStartTime;
            lArray[1] = this.lastStopTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startBehaviorScheduler() {
        Object object = this.intervalTimeLock;
        synchronized (object) {
            this.stopCount = -1;
            this.userStop = false;
            VirtualUniverse.mc.setWork();
        }
    }

    void deactivate() {
        this.active = false;
        if (this.stopCount >= 0) {
            this.userStop = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork(long l) {
        this.lastStartTime = J3dClock.currentTimeMillis();
        if (this.stopCount >= 0) {
            VirtualUniverse.mc.sendRunMessage(this.univ, 1);
            if (--this.stopCount == 0) {
                this.userStop = true;
            }
        }
        for (int i = 0; i < 10; ++i) {
            UnorderList unorderList = this.processList[i];
            if (unorderList.isEmpty()) continue;
            BehaviorRetained[] behaviorRetainedArray = (BehaviorRetained[])unorderList.toArray(false);
            int n = unorderList.arraySize();
            for (int j = 0; j < n; ++j) {
                BehaviorRetained behaviorRetained;
                BehaviorRetained behaviorRetained2 = behaviorRetained = behaviorRetainedArray[j];
                synchronized (behaviorRetained2) {
                    Behavior behavior = (Behavior)behaviorRetained.source;
                    if (!behavior.isLive() || !behaviorRetained.conditionSet || behaviorRetained.wakeupCondition == null) {
                        continue;
                    }
                    if (behaviorRetained.wakeupCondition.trigEnum == null) {
                        behaviorRetained.wakeupCondition.trigEnum = new WakeupCriteriaEnumerator(behaviorRetained.wakeupCondition, 1);
                    } else {
                        behaviorRetained.wakeupCondition.trigEnum.reset(behaviorRetained.wakeupCondition, 1);
                    }
                    behaviorRetained.conditionSet = false;
                    WakeupCondition wakeupCondition = behaviorRetained.wakeupCondition;
                    BehaviorRetained behaviorRetained3 = behaviorRetained;
                    synchronized (behaviorRetained3) {
                        behaviorRetained.inCallback = true;
                        this.univ.inBehavior = true;
                        try {
                            behavior.processStimulus(wakeupCondition.trigEnum);
                        }
                        catch (RuntimeException runtimeException) {
                            behaviorRetained.conditionSet = false;
                            System.err.println("Exception occurred during Behavior execution:");
                            runtimeException.printStackTrace();
                        }
                        this.univ.inBehavior = false;
                        behaviorRetained.inCallback = false;
                    }
                    if (!behaviorRetained.conditionSet) {
                        if (wakeupCondition != null) {
                            wakeupCondition.cleanTree(this.behaviorStructure);
                        }
                        behaviorRetained.wakeupCondition = null;
                        behaviorRetained.active = false;
                        this.scheduleList.remove(behaviorRetained);
                    } else {
                        behaviorRetained.handleLastWakeupOn(wakeupCondition, this.behaviorStructure);
                    }
                    continue;
                }
            }
            unorderList.clear();
        }
        this.behaviorStructure.handleAWTEvent();
        this.behaviorStructure.handleBehaviorPost();
        this.lastStopTime = J3dClock.currentTimeMillis();
    }

    void free() {
        this.behaviorStructure = null;
        this.getThreadData(null, null).thread = null;
        this.univ = null;
        for (int i = 9; i >= 0; --i) {
            this.processList[i].clear();
        }
        this.scheduleList.clear();
    }
}

